// TreePanel.java 
import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;


class TreePanel extends Panel
{
	Label Title;
	TreeSpace TreePane;
	CustomLayout TreeLayout;
	public TreeMouseAdapter TreeMouseListener;
	DispWindow Master;
	ScrollPane TreeScroll;
	Font Fpfont;
	int yshift = 2;

	public TreePanel(DispWindow Master)
	{
		this.Master = Master;
		Fpfont = Master.getMasterFont();
		setFont(Fpfont);
		TreeMouseListener = new TreeMouseAdapter(this);
		setLayout(new BorderLayout());
		TreePane = new TreeSpace();
		TreeLayout = new CustomLayout(this,100,100);
		TreePane.setLayout(TreeLayout);
		TreePane.setFont(Fpfont);
		TreePane.setForeground(Color.black);
		TreePane.setBackground(Color.white);


		Title = new Label("Cur Dir",Label.LEFT);
		TreePane.add(Title);
		TreeLayout.setShape(Title,10,1,100,9);
		TreeScroll = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
		TreeScroll.add(TreePane);
		add("Center",TreeScroll);
	}

	class TreeSpace extends Panel
	{
		public void paint(Graphics g)
		{
			int width = TreeScroll.getScrollPosition().x+getSize().width;
			int bottom = (10*getCharHeight())/8;
			for(int i=bottom;i<bottom+2;i++)
				g.drawLine(0,i,width,i);
		}
	}


	public void addElement(String NodeName,String DispName,int Shift)
	{
		yshift += 10;
		TreeNamePanel DirLabel = new TreeNamePanel(this,NodeName,DispName);
		TreePane.add(DirLabel);
		TreeLayout.setShape(DirLabel,5*Shift,yshift,DispName.length()*4,10);
	}

	public void prepare()
	{
		int width = 150;
		TreeLayout.setSize(this,width,yshift+20);
		TreePane.setVisible(true);
		setVisible(true);

		TreeScroll.getHAdjustable().setBlockIncrement(1+width);
		TreeScroll.getHAdjustable().setUnitIncrement(1+width/10);
		TreeScroll.getVAdjustable().setBlockIncrement(1+yshift);
		TreeScroll.getVAdjustable().setUnitIncrement(1+yshift/10);
	}

	public TreeMouseAdapter getMouseListener()
	{
		return TreeMouseListener;
	}

	public void setSelection(String status)
	{
		//Master.showStatus(status);
		Master.setSelection(status);
	}
	protected int getCharHeight()
	{
		FontMetrics m = getFontMetrics(Master.getMasterFont());
		int height = m.getHeight();
		return height;
	}
}
