// TreeNamePanel.java 

import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

class TreeNamePanel extends Panel
{
	TreePanel Master = null;
	String DirName=null;
	CustomLayout Layout;

	public TreeNamePanel(TreePanel Master,String NodeName,String DispName)
	{
		super();
		this.Master = Master;
		this.DirName = NodeName;
		setFont(Master.Fpfont);

		Layout = new CustomLayout(this,100,10);
		setLayout(Layout);

		addLabel(DispName,0,DispName.length()*4);

		setVisible(true);
	}

	protected void addLabel(String Str,int start,int end)
	{
		String DispStr = new String(Str);
		int strwidth = (end-start)/4;
		try
		{
			DispStr = DispStr.substring(0,strwidth);
		}
		catch(StringIndexOutOfBoundsException e)
		{
		}
		Label DispLabel = new Label(DispStr, Label.LEFT);
		DispLabel.setFont(Master.Fpfont);
		DispLabel.setForeground(Color.black);
		DispLabel.setBackground(Color.white);
		DispLabel.addMouseListener(Master.getMouseListener());
		add(DispLabel);

		start += (12*4)/getCharWidth();
		Layout.setShape(DispLabel,start,0,end-start,10);
		DispLabel.setVisible(true);
	}
	public void setForeground(Color c)
	{
		for(int i=0;i<getComponentCount();++i)
		{
			Component Comp = getComponent(i);
			Comp.setForeground(c);
		}
	}
	public void setBackground(Color c)
	{
		for(int i=0;i<getComponentCount();++i)
		{
			Component Comp = getComponent(i);
			Comp.setBackground(c);
		}
	}
	public Color getForeground()
	{
		Component l = getComponent(0);
		return l.getForeground();
	}
	public Color getBackground()
	{
		Component l = getComponent(0);
		return l.getBackground();
	}
	public String getText()
	{
		return new String(DirName);
	}


	// Implementation Helpers
	protected int getCharWidth()
	{

		FontMetrics m = getFontMetrics(Master.Fpfont);
		String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		int width = m.stringWidth(s) / s.length();

		if (width <= 0)
			width = 1;
		return width;
	}

	protected int getCharHeight()
	{
		FontMetrics m = getFontMetrics(Master.Fpfont);
		int height = m.getHeight();
		return height;
	}
}
