// TreeFtpClient.java 
import sun.net.ftp.*;
import sun.net.*;
import java.net.*;
import java.util.*;
import java.io.*;

class TreeFtpClient extends NewFtpClient
{
	String LocalHost;
	MessageWindow MsgWindow = null;
	TreeFtpClient(String LocalHost,String host,MessageWindow MsgWindow) throws
	IOException
	{
		super(host);
		this.LocalHost = LocalHost;
		this.MsgWindow = MsgWindow;
	}

	public int treeIssueCommand(String cmd)throws IOException
	{
		return super.issueCommand(cmd);
	}

	public void treeIssueCommandCheck(String cmd) throws IOException
	{
		super.issueCommandCheck(cmd);
	}

	protected int readReply()
	throws IOException
	{
		int retval = super.readReply();
		if(MsgWindow != null)
		{
			Vector RespStrings = getResponseStrings();
			for(int i=0;i<RespStrings.size();i++)
				MsgWindow.display((String)RespStrings.elementAt(i));
		}
		else
			System.out.println("Message Pipe is null");

		return retval;
	}

	protected Socket openDataConnection(String cmd) throws IOException 
	{
		ServerSocket portSocket;
		String  portCmd;
		InetAddress myAddress = InetAddress.getByName(LocalHost);
		byte    addr[] = myAddress.getAddress();
		IOException e;

		portSocket = new ServerSocket(0,1);
		//System.out.println(portSocket);
		portCmd = "PORT ";

		/* append host addr */
		for (int i = 0; i < addr.length; i++) {
			portCmd = portCmd + (addr[i] & 0xFF) + ",";
		}

		/* append port number */
		portCmd = portCmd + ((portSocket.getLocalPort() >>> 8) & 0xff) + ","
		+ (portSocket.getLocalPort() & 0xff);
		if (issueCommand(portCmd) == FTP_ERROR) {
			e = new FtpProtocolException("PORT");
			portSocket.close();
			throw e;
		}
		/*
            String AddrStr="";
            int Port = 0;
            if(issueCommand("PASV") == FTP_ERROR)
            {
                    portSocket.close();
                    throw new FtpProtocolException("PASV");
            }
            String Str = getResponseString();
            Str = Str.substring(4);
            if(Str.indexOf('(') != -1)
            {
                    Str = Str.substring(Str.indexOf('(')+1,Str.indexOf(')'));
            }
            else
            {
                    StringTokenizer ST = new StringTokenizer(Str);
                    while(ST.hasMoreTokens())
                    {
                            AddrStr = ST.nextToken();
                    }
                    Str = AddrStr;
            }
            StringTokenizer ST = new StringTokenizer(Str,",");
            if(ST.countTokens()>=6)
            {
                    AddrStr = "";
                    AddrStr = ST.nextToken();
                    for(int i=0;i<3;i++)
                    {
                            AddrStr += "."+ST.nextToken();
                    }
                    Port = new Integer(ST.nextToken()).intValue();
                    Port = Port*256 + new Integer(ST.nextToken()).intValue();
                    //dataSocket = new Socket(InetAddress.getByName(AddrStr),Port,
                                    //myAddress,portSocket.getLocalPort());
            }
            else 
            {
                    //System.out.println("Error in PASV return String");
            }


            dataSocket = new Socket(InetAddress.getByName(AddrStr),Port);
            */
		if (issueCommand(cmd) == FTP_ERROR) {
			e = new FtpProtocolException(cmd);
			portSocket.close();
			throw e;
		}
		dataSocket = portSocket.accept();
		portSocket.close();
		return dataSocket;
	}

	public boolean treeDelete(String NodeName)
	{
		String TmpName = NodeName;
		if(!TmpName.equals(File.separator))
		{
			if(TmpName.endsWith(File.separator))
				TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator)));
			TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator))+1);
		}
		try
		{
			treeCD(TmpName);
			StringTokenizer ST = new StringTokenizer(NodeName,File.separator);
			while(ST.hasMoreTokens())
				TmpName = ST.nextToken();
			issueCommandCheck("DELE "+TmpName);
			return true;
		}
		catch(IOException e)
		{
			return false;
		}
	}


	public String[]  treeList()
	throws IOException
	{
		TelnetInputStream tis = null;
		tis = super.list();
		BufferedReader BFR = new BufferedReader(new InputStreamReader(tis));
		Vector List = new Vector(1);
		String S;
		while((S = BFR.readLine()) != null)
		{
			if(S.equals(".") || S.equals(".."))
				continue;
			StringTokenizer ST = new StringTokenizer(S);
			while(ST.hasMoreTokens())
				S = ST.nextToken();
			List.addElement(S);
		}
		String Slist[] = new String[List.size()];
		List.copyInto(Slist);
		return Slist;
	}

	public void treeCD(String Dir)
	throws IOException
	{

		try
		{
			cd(Dir);
		}

		catch (IOException FtpException)
		{
			/* Well, "/" might not be the file delimitor for this
                       particular ftp server, so let's try a series of
                       "cd" commands to get to the right place. */
			StringTokenizer t = new StringTokenizer(Dir, File.separator);
			String  pathElement = null;

			while (t.hasMoreElements())
			{
				pathElement = t.nextToken();
				try 
				{
					cd(pathElement);
				}
				catch (FtpProtocolException e)
				{
					/* Giving up. */
					throw FtpException;
				}
			}
		}
	}

	public String treeGetToDir(String RemFileName,String LocalDir)
	throws IOException
	{

		if(RemFileName.endsWith(File.separator))
			throw new FtpProtocolException("Cannot Copy Directory");

		int ch;
		TelnetInputStream tis = null;
		int last = RemFileName.lastIndexOf(File.separator);
		treeCD(RemFileName.substring(0,last));
		String DirName = new String(LocalDir);
		File Dir = new File(DirName);
		if(!Dir.exists())
			Dir.mkdirs();
		if(!DirName.endsWith(File.separator))
			DirName += File.separator;
		File LocalFile = new File(DirName+
		RemFileName.substring(last+1));
		tis = super.get(RemFileName.substring(last+1));
		FileOutputStream fos = new FileOutputStream(LocalFile);

		while((ch = tis.read()) >= 0)
			fos.write(ch);
		fos.close();
		return (LocalFile.getAbsolutePath());
	}
	public String treeGet(String RemFileName,String LocalFileName)
	throws IOException
	{

		if(RemFileName.endsWith(File.separator))
			throw new FtpProtocolException("Cannot Copy Directory");

		int ch;
		TelnetInputStream tis = null;
		int last = RemFileName.lastIndexOf(File.separator);
		treeCD(RemFileName.substring(0,last));
		File LocalFile = new File(LocalFileName);

		tis = super.get(RemFileName.substring(last+1));
		FileOutputStream fos = new FileOutputStream(LocalFile);

		while((ch = tis.read()) >= 0)
			fos.write(ch);
		fos.close();
		return (LocalFile.getAbsolutePath());
	}

	public String treePutToDir(String LocalFileName,String RemDir)
	throws IOException
	{
		if(LocalFileName.endsWith(File.separator))
			throw new FtpProtocolException("Cannot Copy Directory");

		int ch;
		TelnetOutputStream tos = null;
		int last = LocalFileName.lastIndexOf(File.separator);
		String RemFileName = null;
		if(RemDir.endsWith(File.separator))
			RemFileName = RemDir+LocalFileName.substring(last+1);
		else
			RemFileName = RemDir+File.separator+LocalFileName.substring(last+1);
		try
		{
			treeCD(RemDir);
		}
		catch(IOException e)
		{
			String Dir = treeCreateDir(RemDir);
			if(Dir == null)
				throw e;
			treeCD(Dir);
		}
		tos = super.put(LocalFileName.substring(last+1));
		FileInputStream fis = new FileInputStream(LocalFileName);
		while((ch=fis.read())>=0)
			tos.write(ch);
		tos.close();
		fis.close();
		return RemFileName;
	}
	public String treePut(String LocalFileName,String RemFileName)
	throws IOException
	{
		if(LocalFileName.endsWith(File.separator))
			throw new FtpProtocolException("Cannot Copy Directory");

		int ch;
		TelnetOutputStream tos = null;
		int last = RemFileName.lastIndexOf(File.separator);
		String RemDir = RemFileName.substring(0,last);
		try
		{
			treeCD(RemDir);
		}
		catch(IOException e)
		{
			String Dir = treeCreateDir(RemDir);
			if(Dir == null)
				throw e;
			treeCD(Dir);
		}
		tos = super.put(RemFileName.substring(last+1));
		FileInputStream fis = new FileInputStream(LocalFileName);
		while((ch=fis.read())>=0)
			tos.write(ch);
		tos.close();
		fis.close();
		return RemFileName;
	}

	public void treeRename(String OldName,String NewName)
	throws IOException
	{
		issueCommandCheck("RNFR "+OldName);
		issueCommandCheck("RNTO "+NewName);
	}

	public String getCurDir()
	throws IOException
	{
		issueCommandCheck("PWD");
		String Dir = getResponseString();
		StringTokenizer st = new StringTokenizer(Dir,"\"");
		st.nextToken();
		if(st.hasMoreTokens())
			Dir = st.nextToken();
		else
			Dir = null;
		return(Dir);

	}
	public String treeCreateDir(String NewDir)
	throws IOException
	{
		if(NewDir.endsWith(File.separator))
			NewDir = NewDir.substring(0,NewDir.lastIndexOf(File.separator));
		issueCommandCheck("MKD "+NewDir);
		String Dir = getResponseString();
		StringTokenizer st = new StringTokenizer(Dir,"\"");
		st.nextToken();
		if(st.hasMoreTokens())
			Dir = st.nextToken();
		else
			Dir = null;
		return(Dir);

	}

	void setMessageWindow(MessageWindow M)
	{
		MsgWindow = M;
	}


}
