// TitleBox.java 
import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

class TitleBox extends Panel
implements MouseMotionListener, MouseListener
{
	Button DateTabButton, SizeTabButton;
	Button TabButton;
	CustomLayout TitleLayout;
	FilePanel Master;
	int OldPos=0;
	boolean Dragging = false;
	boolean Moved = false;
	boolean ShowDate,ShowSize;
	int ButtonWidth = 6;
	public TitleBox(FilePanel Master,boolean ShowDate, boolean ShowSize )
	{
		super();
		addMouseListener(this);
		addMouseMotionListener(this);
		this.Master = Master;
		this.ShowDate = ShowDate;
		this.ShowSize = ShowSize;
		//if(!ShowDate && ShowSize)
		//      Master.setSizeTab(Master.getDateTab());

		int DateTab = (Master.getDateTab()*4)/getCharWidth();
		int SizeTab = (Master.getSizeTab()*4)/getCharWidth();

		TitleLayout = new CustomLayout(Master,SizeTab+60,10);
		setLayout(TitleLayout);

		if(ShowDate)
		{
			DateTabButton = new Button("");
			DateTabButton.addMouseMotionListener(this);
			DateTabButton.addMouseListener(this);
			add(DateTabButton);
			TitleLayout.setShape(DateTabButton,DateTab,0,ButtonWidth,9);
			DateTabButton.setVisible(true);
		}

		if(ShowSize)
		{
			SizeTabButton = new Button("");
			SizeTabButton.addMouseMotionListener(this);
			SizeTabButton.addMouseListener(this);
			add(SizeTabButton);
			TitleLayout.setShape(SizeTabButton,SizeTab,0,ButtonWidth,9);
			SizeTabButton.setVisible(true);
		}

		setVisible(true);
	}

	public void paint(Graphics g)
	{
		int width = Master.getSize().width;
		int bottom = (10*getCharHeight())/8;
		for(int i=bottom;i>bottom-3;i--)
			g.drawLine(0,i,width,i);
		g.drawString(" FileName",2,14);
		if(ShowDate)
			g.drawString(" Last Modified",
			DateTabButton.getLocation().x+ButtonWidth*getCharWidth()/4,14);
		if(ShowSize)
			g.drawString(" File Size",
			SizeTabButton.getLocation().x+ButtonWidth*getCharWidth()/4,14);
	}

	public void mouseDragged(MouseEvent evt)
	{
		if((Dragging)&& (ShowDate || ShowSize))
		{
			Moved = true;
			int shift = evt.getX()-OldPos;
			int newtab = TabButton.getLocation().x + shift;
			newtab = (newtab*4)/getCharWidth();
			newtab += (shift>0)?3:-1;
			if(TabButton == DateTabButton)
			{
				TitleLayout.setShape(DateTabButton,newtab-1,0,ButtonWidth,10);
			}
			else if(TabButton == SizeTabButton)
			{
				TitleLayout.setShape(SizeTabButton,newtab-1,0,ButtonWidth,10);
			}
			doLayout();
			repaint();
		}
		else if(evt.getSource() instanceof Button)
			Dragging = true;
		OldPos = evt.getX();
	}

	public void mouseMoved(MouseEvent evt)
	{
	}

	// Mouse Listener Methods
	public void mouseClicked(MouseEvent evt)
	{
		//Master.showStatus("Clicked");
	}
	public void mouseEntered(MouseEvent evt)
	{
	}
	public void mouseExited(MouseEvent evt)
	{
		if(Dragging)
		{
			Dragging = false;
		}
	}
	public void mousePressed(MouseEvent evt)
	{
		if((evt.getSource() instanceof Button) && (ShowDate || ShowSize))
		{
			TabButton = (Button)evt.getSource();
		}
	}
	public void mouseReleased(MouseEvent evt)
	{
		if((Moved)&& (ShowDate || ShowSize))
		{
			Moved = false;
			if(TabButton == DateTabButton)
			{
				Master.setDateTab(TabButton.getLocation().x);
			}
			else if(TabButton == SizeTabButton)
			{
				Master.setSizeTab(TabButton.getLocation().x);
			}
			repaint();
			Master.display();
		}
		Dragging = false;
	}


	// Implementation Helpers

	protected int getCharWidth()
	{
		FontMetrics m = Master.getFontMetrics(Master.Fpfont);
		String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		int width = m.stringWidth(s) / s.length();

		if (width <= 0)
			width = 1;
		return width;
	}

	protected int getCharHeight()
	{
		FontMetrics m = Master.getFontMetrics(Master.Fpfont);
		int height = m.getHeight();
		return height;
	}
}
