// MessageBox.java
// AWT 1.1.1

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/*
MessageBox is a modal dialog box showing messages to user
optionally sending back the user's response.  Calling 
MessageBox constructor creates a message box with specified
types of buttons.  A call to display() method is needed to show 
the dialog box on screen. Message text is passed as argument
to display().  The message box will be displayed at its
optimum size, centered in the parent frame.
*/

// MessageBox is a Dialog 
class MessageBox extends Dialog implements ActionListener
{
	// Button constants.  Calling methods can now specify
	// multiple buttons in a single argument, by OR ing
	// the constants.
	public static final int OK = 1;
	public static final int CANCEL = 2;
	public static final int RETRY = 4;

	// Create buttons
	Button Ok ;
	Button Cancel;
	Button Retry = new Button("Retry");

	Frame Parent = null;
	// Parent Frame
	int buttons = 0;                
	// Number of buttons
	int buttonPressed = 0;  
	// Contains the button pressed
	StringTokenizer Msg = null; 
	// store the message.
	Font LabelFont = null; 
	// The text font.  Can be changed 
	// by calling setFont() method

	// Constructor
	MessageBox(Frame Parent,int buttons)
	{
		// The last argument to the super's (Dialog class's)
		// constructor specifies the modal nature. 
		super(Parent,Parent.getTitle(),true);
		addWindowListener(new DlgAdapter());

		this.Parent = Parent;
		this.buttons = buttons;
		// Default text Font
		LabelFont = new Font("TimesRoman",Font.PLAIN,12);
	}

	class DlgAdapter extends WindowAdapter
	{
		public void windowClosing(WindowEvent evt)
		{
			dispose();
		}
	}
	// Display the message
	// User can split the message to multiple lines by
	// introducing line breaks('\n') in the text.
	public int  display(String msg)
	{
		// Invoke StringTokenizer class with '\n' as separator
		this.Msg = new StringTokenizer(msg,"\n");
		// Get the number of lines
		int NumLabels = Msg.countTokens();
		// Set layout with gaps between text and buttons as
		// well as at the top and bottom
		setLayout(new GridLayout(NumLabels+4,1,50,0));

		// Provide gap at the top
		add(new Label(""));

		// Add the message text as labels
		for(int i=0;i<NumLabels;i++)
		{
			String NewToken = Msg.nextToken();
			Label CurLabel = new Label(NewToken,Label.CENTER);
			CurLabel.setFont(LabelFont);
			add(CurLabel);
		}

		// Find the number of buttons
		int NumButtons = 0;
		for(int i=1;i<=4;i*=2)
			if((buttons & i) != 0)
				++NumButtons;

		Panel ButtonPanel = new Panel();
		ButtonPanel.setLayout(new GridLayout(1,NumButtons+3));

		Font ButtonFont = new Font("Helvetica",Font.BOLD,12);
		if((buttons & 1)==1)
		{
			ButtonPanel.add(new Label(""));
			Ok = new Button("Ok");
			Ok.addActionListener(this);
			Ok.setFont(ButtonFont);
			ButtonPanel.add(Ok);
		}
		if((buttons & 2)==2)
		{
			ButtonPanel.add(new Label(""));
			Cancel = new Button("Cancel");
			Cancel.addActionListener(this);
			Cancel.setFont(ButtonFont);
			ButtonPanel.add(Cancel);
		}
		if((buttons & 4)==4)
		{
			ButtonPanel.add(new Label(""));
			Retry = new Button("Retry");
			Retry.addActionListener(this);
			Retry.setFont(ButtonFont);
			ButtonPanel.add(Retry);
		}
		ButtonPanel.add(new Label(""));
		ButtonPanel.setVisible(true);

		add(new Label(""));
		add(ButtonPanel);
		add(new Label(""));

		pack();

		//The dialog window once made visible waits for user response 
		//in Openwindows.
		// Check the behaviour in other platforms

		setResizable(false);
		setVisible(true);

		return buttonPressed;
	}

	public void setFont(Font f)
	{
		LabelFont = f;
	}

	public void actionPerformed(ActionEvent evt)
	{
		Object Source = evt.getSource();
		if(Source == Ok)
		{
			buttonPressed = OK;
			dispose();
		}
		else if(Source == Cancel)
		{
			buttonPressed = CANCEL;
			dispose();
		}
		else if(Source == Retry)
		{
			buttonPressed = RETRY;
			dispose();
		}

	}
}
