// GeneralFtpClient.java 

import sun.net.ftp.*;
import sun.net.*;
import java.net.*;
import java.util.*;
import java.io.*;
class GeneralFtpClient extends FtpClient
{

	GeneralFtpClient(String host) throws IOException
	{
		super(host);
	}

	public int generalIssueCommand(String cmd)throws IOException
	{
		return super.issueCommand(cmd);
	}

	public void generalIssueCommandCheck(String cmd) throws IOException
	{
		super.issueCommandCheck(cmd);
	}

	public String getCommand()
	throws IOException
	{
		BufferedReader Reader = new BufferedReader(new InputStreamReader(System.in));
		System.out.print("JFTP> ");
		System.out.flush();
		return(Reader.readLine());
	}

	public boolean processCommand(String Cmd)
	throws IOException
	{
		Cmd = Cmd.trim();
		StringTokenizer CmdStr = new StringTokenizer(Cmd);
		String CmdKey = null;
		if(CmdStr.hasMoreTokens())
			CmdKey = CmdStr.nextToken().toUpperCase();
		else 
			return true;

		if(CmdKey.equals("LIST"))
			generalList();
		else if(CmdKey.equals("RETR"))
			generalGet(Cmd.substring(5));
		else if(CmdKey.equals("STOR"))
			generalPut(Cmd.substring(5));
		else if(CmdKey.equals("QUIT"))
		{
			closeServer();
			return false;
		}
		else if(CmdKey.equals("USER"))
		{
			String User=null,Pass = null;
			if(CmdStr.countTokens()<2)
				throw new IOException("Error : Usage : USER UNAME PASSWORD ");
			User = CmdStr.nextToken();
			Pass = CmdStr.nextToken();
			login(User,Pass);
		}
		else
			generalIssueCommandCheck(Cmd);
		//  readReply();
		return true;

	}

	protected int readReply()
	throws IOException
	{
		int retval = super.readReply();
		Vector RespStrings = getResponseStrings();
		for(int i=0;i<RespStrings.size();i++)
			System.out.print((String)RespStrings.elementAt(i));

		//System.out.println(RespStrings);
		return retval;
	}
	public void generalList()
	throws IOException
	{

		StringBuffer buf = new StringBuffer();
		int ch;
		TelnetInputStream tis = null;
		tis = super.list();

		while((ch = tis.read()) >= 0)
			buf.append((char)ch);
		System.out.println(buf);
	}

	public void generalGet(String fname)
	throws IOException
	{
		int ch;
		TelnetInputStream tis = null;
		tis = super.get(fname);
		FileOutputStream fos = new FileOutputStream(fname);

		while((ch = tis.read()) >= 0)
			fos.write(ch);
		fos.close();
	}
	public void generalPut(String fname)
	throws IOException
	{
		int ch;
		TelnetOutputStream tos = null;
		tos = super.put(fname);
		FileInputStream fis = new FileInputStream(fname);
		while((ch=fis.read())>=0)
			tos.write(ch);
		tos.close();
		fis.close();
	}

}
