// FtpWindow.java 
import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

public class FtpWindow extends Panel // implements ActionListener
implements DispWindow
{
	FtpApp Master;
	FtpSiteTree FileSystem;
	FtpSiteTree CurDir;
	String CurSelection = null;

	Label Title;
	Label StatusBar;
	Label ModeLabel;

	public Font Fpfont;
	Panel CenterPanel;
	TreePanel DirList=null;
	FilePanel FileList=null;
	boolean FormatChanged = false;

	public FtpWindow(FtpApp Master,String LocalHost, String Host,
	String User,String Password,String Dir)
	throws IOException
	{
		super();
		this.Master = (FtpApp)Master;

		FileSystem = new FtpSiteTree (Master.getMessageWindow(),LocalHost,Host,User,Password,Dir);

		//FileSystem.ascii();

		CurDir = FileSystem;
		setLayout(new BorderLayout(2,2));
		Fpfont = Master.Fpfont;
		setFont(Fpfont);

		Title = new Label(Host,Label.CENTER);
		Title.setFont(new Font("SanSerif",Font.BOLD,Fpfont.getSize()));
		deselect();
		add("North",Title);

		Panel Status = new Panel();
		Status.setLayout(new BorderLayout());
		StatusBar = new Label("Started",Label.LEFT);
		ModeLabel = new Label("Mode: Ascii",Label.RIGHT);
		Status.add("East",ModeLabel);
		Status.add("Center",StatusBar);
		add("South",Status);

		DirList = new TreePanel(this);
		FileList = new FilePanel(this);

		CenterPanel = new Panel();
		CenterPanel.setLayout(new GridLayout(1,2));
		CenterPanel.add(DirList);
		CenterPanel.add(FileList);
		CenterPanel.setVisible(true);
		add("Center",CenterPanel);

	}
	public void close()
	{
		try
		{
			FileSystem.closeServer();
		}
		catch(Exception e)
		{
		}
	}

	public void paint(Graphics g)
	{
		Component Comp[] = getComponents();
		for(int i=0;i<Comp.length;i++)
		{
			Rectangle CompRect = Comp[i].getBounds();
			for(int j=0;j<2;j++)
			{
				g.drawRect(CompRect.x-j,CompRect.y-j,
				CompRect.width+j,CompRect.height+j);
			}
		}
	}
	public void display()
	{
		display(FileSystem,false);
	}
	public void display(boolean FilePanelOnly)
	{
		if(FilePanelOnly)
			display(CurDir,true);
		else
			display(FileSystem,false);
	}
	public void display(boolean FormatChanged,boolean FilePanelOnly)
	{
		if(FormatChanged)
			this.FormatChanged = true;
		if(FilePanelOnly)
			display(CurDir,true);
		else
			display(FileSystem,false);
		this.FormatChanged = false;
	}

	public void display(FtpSiteTree Root,boolean FilePanelOnly)
	{
		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		TreePanel TmpDirList = new TreePanel(this);
		FilePanel TmpFileList = new FilePanel(this);
		TmpFileList.addTitle(FileList,FormatChanged);
		try
		{
			int MinTokens = new StringTokenizer(Root.NodeName,File.separator).countTokens();
			if(FilePanelOnly)
				Root = Root.LChild;
			/*
                    if(Root == null)
                    {
                            setCursor(OldCursor);
                            return;
                    }
                    */
			BufferedReader FileTree = Root.readTree();
			String Fname;
			while((Fname = FileTree.readLine())!= null)
			{
				StringTokenizer ST = new StringTokenizer(Fname,
				File.separator);
				int Tokens = ST.countTokens();
				if(Tokens == MinTokens+1)
					TmpFileList.addElement(Fname);
				if(!FilePanelOnly && Fname.endsWith(File.separator))
				{
					String Str = null;
					while(ST.hasMoreElements())
						Str = ST.nextToken();
					if(Str != null)
						TmpDirList.addElement(Fname,Str,Tokens-MinTokens+1);
				}
				//System.out.println("FtpWindow: "+Fname+"  "+Tokens+" "+MinTokens);
			}
			FileTree.close();
		}
		catch (Exception e)
		{
		}
		TmpDirList.prepare();
		TmpFileList.prepare();

		if(!FilePanelOnly)
		{
			CenterPanel.remove(DirList);
			CenterPanel.remove(FileList);
			CenterPanel.add(TmpDirList);
			CenterPanel.add(TmpFileList);
			DirList = TmpDirList;
			FileList = TmpFileList;
		}
		else
		{
			CenterPanel.remove(FileList);
			CenterPanel.add(TmpFileList);
			FileList = TmpFileList;
		}


		CenterPanel.invalidate();
		validateTree();

		setCursor(OldCursor);
	}

	public void updateFilePanel(String NewDir)
	{
		try
		{
			FileSystem.getSubTree(FileSystem,NewDir);
			return;
		}
		catch(FtpSubTreeFoundException e)
		{
			CurDir = e.DirTree;
			display(CurDir,true);
		}
	}

	public void CDUP()
	{

		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		try
		{
			FileSystem = FileSystem.getParentTree();
		}
		catch (Exception e)
		{
			//System.out.println("From CDUP");
			//e.printStackTrace(System.out);
		}
		if(FileSystem == null)
		{
			//System.out.println("Null");
		}
		else
			display(FileSystem,false);
		setCursor(OldCursor);
	}

	public void renFile(String Files[])
	{

		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		if(FileSystem.renameNode(FileSystem,Files[0],Files[1]) == false)
			Master.dispMessage("Rename Failed on Site "+getTitle()+
			"\nFrom: "+Files[0]+
			"\nTo: "+Files[1]);
		else
			setFileRenamed(Files[0]);
		setCursor(OldCursor);
	}

	public void deleteNode()
	{
		String Msg = "Please Select the \nFile/Directory to be deleted";
		if(CurSelection == null)
		{
			new MessageBox(Master,MessageBox.OK).display(Msg);
			return;
		}
		if(CurSelection.endsWith(File.separator))
			Msg = "Delete Remote  Directory\n"+CurSelection;
		else
			Msg = "Delete Remote File\n"+CurSelection;
		int Result = (new MessageBox(Master,MessageBox.OK|MessageBox.CANCEL)).display(Msg);
		if(!(Result == MessageBox.OK))
			return;

		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		if(FileSystem.deleteNode(FileSystem,CurSelection))
		{
			display();
			setSelection(null);
		}
		else 
			(new MessageBox(Master,MessageBox.OK)).display("Delete Failed for\n"+CurSelection);
		setCursor(OldCursor);
	}
	public void copyFile(String[] Files)
	{

		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		try
		{
			File TmpDir = new File(System.getProperty("user.dir"),".ICT");
			if(!TmpDir.exists())
				if(!TmpDir.mkdir())
					throw new FtpProtocolException("Copy Failed\n"+
					"Cannot Make Temporary Directory\n"+TmpDir.getAbsolutePath());

			TreeFtpClient Ftp = FileSystem.getFtp();
			String LocalFile = null;
			String RemFile = null;
			synchronized(Ftp)
			{
				LocalFile  = Ftp.treeGetToDir(Files[0],
				TmpDir.getAbsolutePath());
				if(Files[1].endsWith(File.separator))
					RemFile = Ftp.treePutToDir(LocalFile,Files[1]);
				else
					RemFile = Ftp.treePut(LocalFile,Files[1]);
			}
			setFileCopied(RemFile);
			(new File(LocalFile)).delete();
		}
		catch(FtpProtocolException e)
		{
			Master.dispMessage(e.getMessage());
		}
		catch(Exception e)
		{
			Master.dispMessage(e.getMessage());
		}
		setCursor(OldCursor);
	}
	public TreeFtpClient getFtp()
	{
		return FileSystem.getFtp();
	}
	public void putFile(String[] Files)
	{
		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		try
		{
			TreeFtpClient Ftp = FileSystem.getFtp();
			String RemFile = null;
			synchronized(Ftp)
			{
				if(Files[1].endsWith(File.separator))
					RemFile = Ftp.treePutToDir(Files[0],Files[1]);
				else
					RemFile = Ftp.treePut(Files[0],Files[1]);
			}
			setFileCopied(RemFile);
		}
		catch(FtpProtocolException e)
		{
			Master.dispMessage(e.getMessage());
		}
		catch(Exception e)
		{
		}
		setCursor(OldCursor);

	}
	public String getFile(String[] Files)
	{
		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		try
		{
			TreeFtpClient Ftp = FileSystem.getFtp();
			String LocalFile = null;
			synchronized(Ftp)
			{
				if(Files[1].endsWith(File.separator))
					LocalFile = Ftp.treeGetToDir(Files[0],Files[1]);
				else
					LocalFile = Ftp.treeGet(Files[0],Files[1]);
			}
			setCursor(OldCursor);
			return(LocalFile);
		}
		catch(FtpProtocolException e)
		{
			Master.dispMessage(e.getMessage());
		}
		catch(Exception e)
		{
		}
		setCursor(OldCursor);
		return null;

	}

	public void setMessageWindow(MessageWindow MsgWindow)
	{
		(FileSystem.getFtp()).setMessageWindow(MsgWindow);
	}

	public void setFileRenamed(String NewFile)
	{
		if(!NewFile.startsWith(FileSystem.NodeName))
			return;
		if(NewFile.startsWith(CurDir.NodeName))
			display(CurDir,true);
	}
	public void setFileCopied(String NewFile)
	{
		if(!NewFile.startsWith(FileSystem.NodeName))
			return;
		FileSystem.insertNode(FileSystem,NewFile);
		if(NewFile.startsWith(CurDir.NodeName))
			display(CurDir,true);
	}

	public void select()
	{
		Title.setBackground(Color.blue);
		Title.setForeground(Color.white);
	}
	public void deselect()
	{
		Title.setBackground(Color.white);
		Title.setForeground(Color.black);
	}
	public String getCurSelection()
	{
		return CurSelection;
	}
	public String getTitle()
	{
		return Title.getText();
	}

	public Font getMasterFont()
	{
		return Fpfont;
	}

	public void showStatus(String Status)
	{
		StatusBar.setText(Status);
		//Master.showStatus(Status);
	}
	public void ascii()
	{
		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		try
		{
			FileSystem.ascii();
			ModeLabel.setText("Mode: Ascii");
		}
		catch(IOException e)
		{
		}
		setCursor(OldCursor);
	}
	public void binary()
	{

		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		try
		{
			FileSystem.binary();
			ModeLabel.setText("Mode: Binary");
		}
		catch(IOException e)
		{
		}
		setCursor(OldCursor);
	}

	public void setSelection(String Selection)
	{
		if(Selection != null)
			StatusBar.setText(Selection);
		else
			StatusBar.setText("");
		CurSelection = Selection;
		Master.setActiveWindow(this);
	}

}
