// FtpSiteTree.java 
//FtpSiteTree.java

//Package
//package prj;

import java.io.*;
import java.util.*;


public class FtpSiteTree 
implements Runnable
{

	public FtpSiteTree LChild = null; 
	// First child
	public FtpSiteTree RChild = null; 
	// Link to remaining children
	protected static int NumNodes = 0;  
	// Count the number of nodes
	String NodeName = null;
	TreeFtpClient Ftp = null;

	//Siblings to the right of the current node
	String[] Siblings = null;

	//the printing thread checks for this flag before proceeding
	boolean finished = false;

	FtpSiteTree TraversedSubTree = null;



	/*
    static PipedWriter PipedOut; 
    static PipedReader PipedIn;
    static PrintWriter MsgOut;
    static
    {
            try
            {
                    PipedOut = new PipedWriter();
                    PipedIn = new PipedReader(PipedOut);
                    MsgOut = new PrintWriter(PipedOut,true);
            }
            catch (Exception e)
            {
            }
    }
    */

	// Access method for number of nodes
	public int getNumNodes()
	{
		return NumNodes;
	}

	public FtpSiteTree()
	{
	}

	public FtpSiteTree(TreeFtpClient Ftp,String NodeName)
	{
		this.Ftp = Ftp;
		this.NodeName = NodeName;
		this.finished = true;
	}
	public FtpSiteTree (MessageWindow MsgWindow,String LocalHost,String Host,String User, 
	String Pass,String NodeName)
	throws IOException
	{
		this(MsgWindow,LocalHost,Host,User,Pass,NodeName,null);
	}

	/*
    public FtpSiteTree (String NodeName)
            throws IOException
    {
            this(null,NodeName,null);
    }
    */

	public FtpSiteTree (FtpSiteTree FST,TreeFtpClient Ftp,String NodeName)
	throws IOException
	{
		this(FST,Ftp,NodeName,null);
	}

	public FtpSiteTree (FtpSiteTree FST,TreeFtpClient Ftp,String NodeName,String[] Siblings)
	throws IOException
	{
		this.TraversedSubTree = FST;
		this.Ftp = Ftp;
		this.NodeName = NodeName;
		this.Siblings = Siblings;

		// Increment number of nodes
		++NumNodes;
		new Thread(this,NodeName).start();
	}
	public FtpSiteTree (MessageWindow MsgWindow,String LocalHost,String Host,
	String User, String Pass, String NodeName,String[] Siblings)
	throws IOException
	{
		if(Ftp == null)
		{
			Ftp = new TreeFtpClient(LocalHost,Host,MsgWindow);
			Ftp.login(User,Pass);
		}
		if(NodeName == null)
			this.NodeName = Ftp.getCurDir();
		else
			this.NodeName = NodeName;
		this.Siblings = Siblings;

		// Increment number of nodes
		++NumNodes;
		new Thread(this,this.NodeName).start();
	}

	public TreeFtpClient getFtp()
	{
		return Ftp;
	}

	public synchronized void run()
	{
		synchronized(Ftp)
		{
			try
			{

				try
				{
					// Add left child for a directory
					//System.out.println("CD to : "+NodeName);
					Ftp.treeCD(NodeName);
					if(!NodeName.endsWith(File.separator))
						NodeName += File.separator;
					boolean LChildProcessed = false;
					if(TraversedSubTree != null)
					{
						if(NodeName.equals(TraversedSubTree.NodeName))
						{
							LChild = TraversedSubTree.LChild;
							TraversedSubTree = null;
							LChildProcessed = true;
						}
					}
					if(!LChildProcessed)
					{
						// Get the directory listing
						String[] DirList = Ftp.treeList();

						// The arraycopy will throw exception if 
						// length of list is zero.
						if(DirList.length>0)
						{
							for(int i=0;i<DirList.length;i++)
								DirList[i] = NodeName+DirList[i];
							String Child = DirList[0];
							String[] Siblgs = new String[DirList.length-1];
							System.arraycopy(DirList,1,Siblgs,0,Siblgs.length);

							// Create a left child
							LChild = new FtpSiteTree(TraversedSubTree,Ftp,Child,Siblgs);
						}
					}
				}
				catch(IOException e)
				{
				}

				// Add siblings to the right
				if(Siblings!=null)
				{
					// Arraycopy will throw exception if length
					// of the string is less than two.
					if(Siblings.length>1)
					{
						String Child = Siblings[0];
						String[] Siblgs = new String[Siblings.length-1];
						System.arraycopy(Siblings,1,Siblgs,0,Siblgs.length);

						// Create new thread to process the remaining
						// siblings. 
						RChild = new FtpSiteTree (TraversedSubTree,Ftp,Child,Siblgs);
					}
					// this is the last sibling
else if (Siblings.length == 1)
{
	RChild = new FtpSiteTree (TraversedSubTree,Ftp,Siblings[0]);
}
				}

			}
			catch(Exception e)
			{
				//e.printStackTrace(System.out);
			}
			// Set the finished flag to true so that other threads
			// can  process the node
			finished = true;
			Siblings = null;
			--NumNodes;
		}
	}

	public FtpSiteTree getParentTree()
	throws IOException
	{
		String Str = NodeName;
		if(Str.endsWith(File.separator))
			Str = Str.substring(0,(Str.lastIndexOf(File.separator)));
		Str = Str.substring(0,Str.lastIndexOf(File.separator));
		return (new FtpSiteTree(this,Ftp,Str,null));
	}

	public FtpSiteTree getSubTree(FtpSiteTree FST,String NodeName)
	throws FtpSubTreeFoundException
	{
		if(FST == null)
			return null;
		if(FST.NodeName.equals(NodeName))
			throw new FtpSubTreeFoundException(FST);
		getSubTree(FST.RChild,NodeName);
		getSubTree(FST.LChild,NodeName);
		return null;
	}


	public boolean renameNode(FtpSiteTree Root,
	String OldName, String NewName)
	{
		try
		{
			Ftp.treeRename(OldName,NewName);
			try
			{
				Root.getSubTree(Root,OldName);
				return false;
			}
			catch(FtpSubTreeFoundException e)
			{
				e.DirTree.NodeName = NewName;
				return true;
			}
		}
		catch(IOException e)
		{
			return false;
		}
	}
	public boolean deleteNode(FtpSiteTree Root,String NodeName)
	{
		//System.out.println("deleteNode:"+NodeName);
		String TmpName = NodeName;
		if(TmpName.endsWith(File.separator))
			TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator)));
		TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator))+1);
		//System.out.println("TmpName1 = "+TmpName);
		try
		{
			Root.getSubTree(Root,TmpName);
			//System.out.println("Subtree search failed");
			return false;
		}
		catch(FtpSubTreeFoundException e)
		{
			TmpName = NodeName;
			try
			{
				if(Ftp.treeDelete(TmpName))
				{
					if(e.DirTree.LChild.NodeName.equals(NodeName))
						e.DirTree.LChild = e.DirTree.LChild.RChild;
					else 
					{
						FtpSiteTree TmpTree = new FtpSiteTree();
						TmpTree = e.DirTree.LChild;
						boolean Finished = false;
						while(! Finished)
						{
							if(TmpTree.RChild.NodeName.equals(NodeName))
							{
								TmpTree.RChild = TmpTree.RChild.RChild;
								Finished = true;
							}
							else
								TmpTree = TmpTree.RChild;
						}
					}
					//System.out.println("Deleted");
					return true;
				}
				else 
					return false;
			}
			catch(Exception e1)
			{
				return false;
			}
		}
	}

	public boolean insertNode(FtpSiteTree Root,String NodeName)
	{
		FtpSiteTree NewNode = new FtpSiteTree(Ftp,NodeName);
		if(!insertNode(Root,NewNode))
		{
			String TmpName = new String(NodeName);
			if(TmpName.endsWith(File.separator))
				TmpName = TmpName.substring(0,
				(TmpName.lastIndexOf(File.separator)));
			TmpName = TmpName.substring(0,
			(TmpName.lastIndexOf(File.separator))+1);
			insertNode(Root,TmpName);
			insertNode(Root,NodeName);
		}
		return(true);
	}

	public static boolean insertNode(FtpSiteTree Root,FtpSiteTree NewNode)
	{
		String FileName = NewNode.NodeName;
		//System.out.println("insertNode:"+FileName);
		String TmpName = new String(FileName);
		if(TmpName.endsWith(File.separator))
			TmpName = TmpName.substring(0,
			(TmpName.lastIndexOf(File.separator)));
		TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator))+1);
		//System.out.println("TmpName1 = "+TmpName);
		try
		{
			Root.getSubTree(Root,TmpName);
			//System.out.println("Subtree search failed");
			return false;
		}
		catch(FtpSubTreeFoundException e)
		{
			try
			{
				if(e.DirTree.LChild == null)
					e.DirTree.LChild = NewNode;
				else if(FileName.compareTo(e.DirTree.LChild.NodeName)<0)
				{
					NewNode.RChild = e.DirTree.LChild;
					e.DirTree.LChild = NewNode;
				}
				else 
				{
					FtpSiteTree TmpTree = e.DirTree.LChild;
					boolean Finished = false;
					while(! Finished)
					{
						if(TmpTree.RChild == null)
						{
							TmpTree.RChild = NewNode;
							Finished = true;
						}
						else if(FileName.compareTo(TmpTree.RChild.NodeName)<0)
						{
							NewNode.RChild = TmpTree.RChild;
							TmpTree.RChild = NewNode;
							Finished = true;
						}
						else
							TmpTree = TmpTree.RChild;
					}
				}
				//System.out.println("Inserted");
				return true;
			}
			catch(Exception e1)
			{
				return false;
			}
		}
	}
	public BufferedReader readTree()
	throws IOException
	{
		PipedWriter PW = new PipedWriter();
		PipedReader PR = new PipedReader(PW);
		new FtpPrinter(this,PW);
		return (new BufferedReader(PR));
	}

	// Print the tree. Recursive function
	// Pre-order traversal of the binary tree will give the 
	// directory tree as it is.
	static void printTree(FtpSiteTree Root, PrintWriter Out)
	{
		// Terminating condition
		if(Root == null)
			return;

		// Wait until the node is constructed properly.
		while(Root.finished == false)
			Thread.yield();
		Out.println(Root.NodeName);


		//MsgOut.println("Nodes:"+NumNodes+" PrintTree : "+Root.NodeName);
		printTree(Root.LChild,Out);
		printTree(Root.RChild,Out);
	}


	public void ascii()
	throws IOException
	{
		Ftp.ascii();
	}
	public void binary()
	throws IOException
	{
		Ftp.binary();
	}
	public void closeServer()
	throws IOException
	{
		Ftp.closeServer();
		/*
            PipedOut.close();
            MsgOut.close();
            */
	}



	/*
    public static void main(String args[])
            throws Exception
    {
            FtpSiteTree Root = 
                    new FtpSiteTree ("cdacb.ernet.in","cdacb","java",
                                            "java123","/export/home/java/bijoy/prj/tree");

            // Start the resource monitor
            new ResourceMonitor();
            
            String Str;

            BufferedReader BR = Root.readTree();
            while((Str = BR.readLine()) !=null)
                    System.out.println("Tree: "+Str);
            Root.closeServer();
    }
    */

}

class FtpPrinter extends Thread
{
	FtpSiteTree Root;
	PipedWriter PW;
	PrintWriter Printer;
	FtpPrinter(FtpSiteTree Root,PipedWriter PW)
	{
		this.Root = Root;
		this.PW = PW;
		Printer = new PrintWriter(PW,true);
		start();
	}

	public void run()
	{
		Root.printTree(Root,Printer);
		Printer.close();
	}
}

