// FtpMenu.java 
import java.awt.*;
import java.awt.event.*;

class FtpMenu extends MenuBar
implements ActionListener, ItemListener
{
	FtpApp Master;
	Menu File,View, Options,Help;
	MenuItem FileOpen,FileClose, FileCDUP,FileCopy,
	FileMove,FileRename,FileDelete,FileExit;
	CheckboxMenuItem ViewDate, ViewSize;
	MenuItem OptionsAscii, OptionsBinary,ViewMessages;
	MenuItem OptionsFont;
	MenuItem HelpAbout;

	FtpMenu(FtpApp Master)
	{
		super();
		this.Master = Master;
		File = new Menu("File");
		add(File);

		FileOpen = new MenuItem("Open Site");
		FileOpen.addActionListener(this);
		File.add(FileOpen);

		FileClose = new MenuItem("Close Site");
		FileClose.addActionListener(this);
		File.add(FileClose);

		File.addSeparator();

		FileCDUP = new MenuItem("CDUP");
		FileCDUP.addActionListener(this);
		File.add(FileCDUP);

		File.addSeparator();

		FileCopy = new MenuItem("Copy");
		FileCopy.addActionListener(this);
		File.add(FileCopy);

		/*
            FileMove = new MenuItem("Move");
            FileMove.addActionListener(this);
            File.add(FileMove);
            */

		FileRename = new MenuItem("Rename");
		FileRename.addActionListener(this);
		File.add(FileRename);

		FileDelete = new MenuItem("Delete");
		FileDelete.addActionListener(this);
		File.add(FileDelete);

		File.addSeparator();

		FileExit = new MenuItem("Exit");
		FileExit.addActionListener(this);
		File.add(FileExit);

		View = new Menu("View");
		add(View);

		ViewDate = new CheckboxMenuItem("Date");
		ViewDate.addItemListener(this);
		View.add(ViewDate);

		ViewSize = new CheckboxMenuItem("Size");
		ViewSize.addItemListener(this);
		View.add(ViewSize);

		View.addSeparator();

		ViewMessages = new MenuItem("Message Window");
		ViewMessages.addActionListener(this);
		View.add(ViewMessages);

		Options = new Menu("Options");
		add(Options);

		OptionsAscii = new MenuItem("Ascii");
		OptionsAscii.addActionListener(this);
		Options.add(OptionsAscii);

		OptionsBinary = new MenuItem("Binary");
		OptionsBinary.addActionListener(this);
		Options.add(OptionsBinary);

		OptionsFont = new MenuItem("Font");
		OptionsFont.addActionListener(this);
		Options.add(OptionsFont);

		Help = new Menu("Help");
		add(Help);

		HelpAbout = new MenuItem("About");
		HelpAbout.addActionListener(this);
		Help.add(HelpAbout);

	}

	public void actionPerformed(ActionEvent Evt)
	{
		MenuItem Target = (MenuItem) Evt.getSource();

		if(Target == FileOpen)
		{
			Master.dispDialog("FILEOPEN");
		}
		else if(Target == FileClose)
		{
			Master.dispDialog("FILECLOSE");
		}
		else if(Target == FileExit)
		{
			Master.terminate();
		}
		else if(Target == FileCDUP)
		{
			Master.CDUP();
		}
		else if(Target == FileDelete)
		{
			Master.deleteNode();
		}
		else if(Target == FileCopy)
		{
			Master.dispDialog("FILECOPY");
		}
		else if(Target == FileRename)
		{
			Master.dispDialog("FILEREN");
		}
		else if(Target == OptionsAscii)
		{
			Master.getActiveWindow().ascii();
		}
		else if(Target == OptionsBinary)
		{
			Master.getActiveWindow().binary();
		}
		else if(Target == ViewMessages)
		{
			Master.openMessageWindow();
		}
	}

	public void itemStateChanged(ItemEvent Evt)
	{
		if(Evt.getSource() == ViewDate)
			Master.setShowDate(!Master.getShowDate());
		else if(Evt.getSource() == ViewSize)
			Master.setShowSize(!Master.getShowSize());
	}

}
