// FtpDialogOpen.java 
import java.awt.*;
import java.awt.event.*;

public class FtpDialogOpen extends Dialog
implements ActionListener
{
	FtpApp Master;
	TextField HostText,UserText,PassText,DirText;
	Button Ok,Cancel;
	CustomLayout DispLayout;

	class DlgAdapter extends WindowAdapter
	{
		public void windowClosing(WindowEvent evt)
		{
			dispose();
		}
	}
	public FtpDialogOpen(FtpApp Master,String Title)
	{
		super(Master,Title,true);
		addWindowListener(new DlgAdapter());
		this.Master = Master;
		setFont(new Font("Monospaced",Font.PLAIN,14));

		Panel DispPanel = new Panel();
		DispPanel.setFont(new Font("Monospaced",Font.PLAIN,14));
		DispLayout = new CustomLayout(this,100,100);
		add(DispPanel,"Center");
		DispPanel.setLayout(DispLayout);

		HostText = new TextField("",15);
		HostText.setEditable(true);
		HostText.setVisible(true);

		UserText = new TextField("",15);
		UserText.setEditable(true);
		UserText.setVisible(true);

		PassText = new TextField("",15);
		PassText.setEditable(true);
		PassText.setEchoChar('*');
		PassText.setVisible(true);

		DirText = new TextField("",15);
		DirText.setEditable(true);
		DirText.setVisible(true);


		Label HostLabel = new Label("Open Host:",Label.RIGHT);
		DispPanel.add(HostLabel);
		DispLayout.setShape(HostLabel,5,5,70,10);

		DispPanel.add(HostText);
		DispLayout.setShape(HostText,80,5,100,15);

		Label UserLabel = new Label("User Name:",Label.RIGHT);
		DispPanel.add(UserLabel);
		DispLayout.setShape(UserLabel,5,25,70,10);

		DispPanel.add(UserText);
		DispLayout.setShape(UserText,80,25,100,15);

		Label PassLabel = new Label("Password:",Label.RIGHT);
		DispPanel.add(PassLabel);
		DispLayout.setShape(PassLabel,5,45,70,10);

		DispPanel.add(PassText);
		DispLayout.setShape(PassText,80,45,100,15);

		Label DirLabel = new Label("Directory:",Label.RIGHT);
		DispPanel.add(DirLabel);
		DispLayout.setShape(DirLabel,5,65,70,10);

		DispPanel.add(DirText);
		DispLayout.setShape(DirText,80,65,100,15);


		Ok = new Button("Ok");
		Ok.addActionListener(this);
		DispPanel.add(Ok);
		DispLayout.setShape(Ok,35,100,30,10);

		Cancel = new Button("Cancel");
		Cancel.addActionListener(this);
		DispPanel.add(Cancel);
		DispLayout.setShape(Cancel,135,100,30,10);

		DispLayout.setSize(this,200,120);

		DispPanel.setVisible(true);
		pack();
		show();
	}

	public void actionPerformed(ActionEvent Evt)
	{
		Button Target = (Button) Evt.getSource();
		if(Target == Ok)
		{
			dispose();

			String Host = HostText.getText().trim();
			if(Host.length()<1)
				Host = null;

			String User = UserText.getText().trim();
			if(User.length()<1)
				User = null;

			String Pass = PassText.getText().trim();
			if(Pass.length()<1)
				Pass = null;

			String Dir = DirText.getText().trim();
			if(Dir.length()<1)
				Dir = null;

			Master.openSite(Host,User,Pass,Dir);
		}
		else if(Target == Cancel)
			dispose();

	}



}
