// FtpDialogClose.java 
import java.awt.*;
import java.awt.event.*;

public class FtpDialogClose extends Dialog
implements ItemListener, ActionListener
{
	FtpApp Master;
	List WindList;
	Button Ok,Cancel;
	CustomLayout DispLayout;
	Label ConfirmLabel;

	class DlgAdapter extends WindowAdapter
	{
		public void windowClosing(WindowEvent evt)
		{
			dispose();
		}
	}
	public FtpDialogClose(FtpApp Master,String Title)
	{
		super(Master,Title,true);
		addWindowListener(new DlgAdapter());
		this.Master = Master;
		setFont(new Font("Monospaced",Font.PLAIN,14));

		Panel DispPanel = new Panel();
		DispPanel.setFont(new Font("Monospaced",Font.PLAIN,14));
		DispLayout = new CustomLayout(this,100,100);
		add(DispPanel,"Center");
		DispPanel.setLayout(DispLayout);


		WindList = new List(2);
		WindList.addItemListener(this);

		String Str;
		Component Comp[] = Master.getFtpWindows();
		DispWindow ActiveWindow = Master.getActiveWindow();
		for(int i=1;i<Comp.length;i++)
		{
			Str = ((DispWindow)Comp[i]).getTitle();
			WindList.addItem(Str);
			if(Comp[i] == ActiveWindow)
				WindList.select(i);
		}

		Label SelectLabel = new Label("Select Site:");
		DispPanel.add(SelectLabel);
		DispLayout.setShape(SelectLabel,10,10,75,10);

		DispPanel.add(WindList);
		DispLayout.setShape(WindList,40,30,80,30);

		ConfirmLabel = new Label("Close Site: "+ActiveWindow.getTitle());
		DispPanel.add(ConfirmLabel);
		DispLayout.setShape(ConfirmLabel,10,70,100,10);


		Ok = new Button("Ok");
		Ok.addActionListener(this);
		DispPanel.add(Ok);
		DispLayout.setShape(Ok,20,80,30,10);

		Cancel = new Button("Cancel");
		Cancel.addActionListener(this);
		DispPanel.add(Cancel);
		DispLayout.setShape(Cancel,70,80,30,10);

		DispLayout.setSize(this,120,100);

		DispPanel.setVisible(true);
		pack();
		show();
	}

	public void itemStateChanged(ItemEvent evt)
	{
		String WindowName;
		WindowName = WindList.getSelectedItem();
		ConfirmLabel.setText("Close Site: "+WindowName);
	}
	public void actionPerformed(ActionEvent Evt)
	{
		Button Target = (Button) Evt.getSource();
		if(Target == Ok)
		{
			dispose();
			Master.closeSite(WindList.getSelectedItem());
		}
		else if(Target == Cancel)
			dispose();

	}



}
