// FtpDialog.java 
import java.awt.*;
import java.awt.event.*;

public class FtpDialog extends Dialog
implements ItemListener, ActionListener
{
	FtpApp Master;
	List SrcList,DestList;
	TextField SrcText,DestText;
	Button Ok,Cancel;
	CustomLayout DispLayout;

	class DlgAdapter extends WindowAdapter
	{
		public void windowClosing(WindowEvent evt)
		{
			dispose();
		}
	}
	public FtpDialog(FtpApp Master,String Title)
	{
		super(Master,Title,true);
		addWindowListener(new DlgAdapter());
		this.Master = Master;
		setFont(new Font("Monospaced",Font.PLAIN,14));

		Panel DispPanel = new Panel();
		DispPanel.setFont(new Font("Monospaced",Font.PLAIN,14));
		DispLayout = new CustomLayout(this,100,100);
		add(DispPanel,"Center");
		DispPanel.setLayout(DispLayout);

		SrcText = new TextField(10);
		SrcText.setEditable(true);
		SrcText.setVisible(true);
		DestText = new TextField(10);
		DestText.setEditable(true);
		DestText.setVisible(true);

		SrcList = new List(2);
		SrcList.addItemListener(this);
		DestList = new List(2);
		DestList.addItemListener(this);

		String Str;
		Component Comp[] = Master.getFtpWindows();
		for(int i=0;i<Comp.length;i++)
		{
			Str = ((DispWindow)Comp[i]).getTitle();
			SrcList.addItem(Str);
			DestList.addItem(Str);
		}
		if(Comp.length>0)
		{
			String Str1 = ((DispWindow)Comp[0]).getCurSelection();
			SrcText.setText(Str1);
			if(Comp.length>1)
			{
				String Str2 = ((DispWindow)Comp[1]).getCurSelection();
				DestText.setText(Str2);
			}
			else 
				DestText.setText(Str1);
		}

		Label FromLabel = new Label("From");
		DispPanel.add(FromLabel);
		DispLayout.setShape(FromLabel,10,5,70,10);

		DispPanel.add(SrcText);
		DispLayout.setShape(SrcText,10,18,90,15);

		Label ToLabel = new Label("To");
		DispPanel.add(ToLabel);
		DispLayout.setShape(ToLabel,10,40,70,10);

		DispPanel.add(DestText);
		DispLayout.setShape(DestText,10,53,90,15);

		Label SrcSelLabel = new Label("Select Source Window");
		DispPanel.add(SrcSelLabel);
		DispLayout.setShape(SrcSelLabel,100,5,100,10);

		DispPanel.add(SrcList);
		DispLayout.setShape(SrcList,100,18,80,20);

		Label DestSelLabel = new Label("Select Destination Window");
		DispPanel.add(DestSelLabel);
		DispLayout.setShape(DestSelLabel,100,40,100,10);

		DispPanel.add(DestList);
		DispLayout.setShape(DestList,100,53,80,20);

		Ok = new Button("Ok");
		Ok.addActionListener(this);
		DispPanel.add(Ok);
		DispLayout.setShape(Ok,35,80,30,10);

		Cancel = new Button("Cancel");
		Cancel.addActionListener(this);
		DispPanel.add(Cancel);
		DispLayout.setShape(Cancel,135,80,30,10);

		DispLayout.setSize(this,200,100);

		DispPanel.setVisible(true);
		pack();
		show();
	}

	public void itemStateChanged(ItemEvent evt)
	{
		String WindowName,Selection;
		List Target = (List) evt.getSource();
		if(Target == SrcList)
		{
			WindowName = SrcList.getSelectedItem();
			if(WindowName != null)
			{
				Selection = Master.getSelection(WindowName);
				if(Selection!=null)
					SrcText.setText(Selection);
				else
					SrcText.setText("");
			}
		}
		else if(Target == DestList)
		{
			WindowName = DestList.getSelectedItem();
			if(WindowName != null)
			{
				Selection = Master.getSelection(WindowName);
				if(Selection!=null)
					DestText.setText(Selection);
				else
					DestText.setText("");
			}
		}
	}
	public void actionPerformed(ActionEvent Evt)
	{
		Button Target = (Button) Evt.getSource();
		if(Target == Ok)
		{
			String[] Files = new String[2];
			Files[0] = SrcText.getText();
			Files[1] = DestText.getText();
			dispose();
			Master.copyFile(Files);
		}
		else if(Target == Cancel)
			dispose();

	}



}
