// FtpApp.java 
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.lang.*;

public class FtpApp  extends Frame 
//implements ActionListener
{
	FtpMenu MainMenu;
	Label MainStatus ;
	static FileWindow LocalSite;
	static FtpWindow FtpPanel;
	static DispWindow ActiveWindow;
	WorkPanel WorkSpace;
	public Font Fpfont;
	String LocalHost = "198.202.189.127";
	MessageWindow MsgWindow;

	public FtpApp(String title)
	{
		super(title);
		addWindowListener(new MasterAdapter());
	}
	public void init()
	{
		Fpfont = new Font("SansSerif",Font.PLAIN,12);
		setFont(Fpfont);
		MainStatus = new Label("Application Started",Label.LEFT);
		setLayout(new BorderLayout(3,3));
		MainMenu = new FtpMenu(this);
		setMenuBar(MainMenu);
		add("South",MainStatus);
		WorkSpace = new WorkPanel();
		add("Center",WorkSpace);

		/*          //Temporary
                    Button FWOk = new Button("Ok");
                    FWOk.addActionListener(this);
                    add("West",FWOk);
*/
	}

	class MasterAdapter extends WindowAdapter
	{
		public void windowClosing(WindowEvent evt)
		{
			Component Comp[] = getFtpWindows();
			for(int i=1;i<Comp.length;i++)
			{
				((DispWindow)Comp[i]).close();
			}
			System.exit(0);
		}
	}

	public MessageWindow getMessageWindow()
	{
		return MsgWindow;
	}
	public void openMessageWindow()
	{
		try
		{
			MsgWindow = new MessageWindow(this);
		}
		catch(Exception e)
		{
			dispMessage("Cannot Open Message Window");
			return;
		}
		Component Comp[] = getFtpWindows();
		for(int i=1;i<Comp.length;i++)
		{
			((DispWindow)Comp[i]).setMessageWindow(MsgWindow);
		}
		return;
	}

	public void closeMessageWindow()
	{
		Component Comp[] = getFtpWindows();
		for(int i=1;i<Comp.length;i++)
		{
			((DispWindow)Comp[i]).setMessageWindow(null);
		}
		return;
	}


	public void addWindow(Component NewWin)
	{
		Component Comp[] = WorkSpace.getComponents();
		int count = Comp.length;
		WorkPanel NewWS = new WorkPanel();
		NewWS.setLayout(new GridLayout(0,1,2,2));
		for(int i=0;i<count;i++)
		{
			NewWS.add(Comp[i]);
		}
		NewWS.add(NewWin);
		NewWS.setVisible(true);
		remove(WorkSpace);
		add("Center",NewWS);
		WorkSpace = NewWS;
		WorkSpace.invalidate();
		validateTree();
	}

	public void removeWindow(Component Window)
	{
		if((DispWindow)Window == LocalSite)
		{
			dispMessage("Cannot Remove Local Site Window");
			return;
		}
		Component Comp[] = WorkSpace.getComponents();
		WorkPanel NewWS = new WorkPanel();
		NewWS.setLayout(new GridLayout(0,1,2,2));
		for(int i=0;i<Comp.length;i++)
		{
			if(Comp[i] != Window)
				NewWS.add(Comp[i]);
		}
		NewWS.setVisible(true);
		remove(WorkSpace);
		add("Center",NewWS);
		WorkSpace = NewWS;
		WorkSpace.invalidate();
		validateTree();
	}

	public void showStatus(String status)
	{
		MainStatus.setText(status);
	}

	public static void main(String[] args)
	throws IOException
	{
		//new ResourceMonitor(2000);

		FtpApp app = new FtpApp ("Multi-Window FTP System");

		app.setSize(800,800);
		app.init();

		LocalSite= new FileWindow(app);
		LocalSite.display();

		//          FtpPanel = new FtpWindow(app,"cdacb.ernet.in","cdacb.ernet.in",
		//                      "java","java123","/export/home/java/bijoy/prj/tree/tmp");
		//          FtpPanel.display();

		//          app.setActiveWindow(FtpPanel);
		app.addWindow(LocalSite);
		//          app.addWindow(FtpPanel);

		//app.openSite("202.141.63.209","guest","guest123",null);

		app.setVisible(true);
		//new MessageBox(app,MessageBox.OK|MessageBox.CANCEL).display("Check the Display");

	}

	public void paint(Graphics g)
	{
		Component Comp[] = getComponents();
		for(int i=0;i<Comp.length;i++)
		{
			Rectangle CompRect = Comp[i].getBounds();
			for(int j=0;j<2;j++)
			{
				g.drawRect(CompRect.x-j,CompRect.y-j,
				CompRect.width+j,CompRect.height+j);
			}
		}
	}
	/*
    public void  actionPerformed(ActionEvent evt)
    {
            Object Source = evt.getSource();
            if(Source instanceof Button)
            {
                    System.exit(0);
            }
    }
    */

	public void terminate()
	{
		System.exit(0);
	}
	public void CDUP()
	{
		ActiveWindow.CDUP();
	}
	public void deleteNode()
	{
		ActiveWindow.deleteNode();
	}
	public void dispDialog(String DlgName)
	{
		if(DlgName == "FILECOPY")
			new FtpDialogCopy(this,"Copy File");
		else if(DlgName == "FILEREN")
			new FtpDialogRen(this,"Rename File");
		else if(DlgName == "FILEOPEN")
			new FtpDialogOpen(this,"Open Site");
		else if(DlgName == "FILECLOSE")
		{
			if(getFtpWindows().length <= 1)
			{
				dispMessage("Cannot close Local Site");
				return;
			}
			new FtpDialogClose(this,"Close Site");
		}
	}
	public void copyFile(String[] Hosts,String[] Files)
	{
		//System.out.println(Hosts[0] + "   " + Files[0]);
		//System.out.println(Hosts[1] + "  " + Files[1]);
		DispWindow SrcSite,DestSite;
		SrcSite = getSite(Hosts[0]);
		DestSite = getSite(Hosts[1]);
		if(SrcSite == DestSite)
		{
			if(SrcSite == LocalSite)
			{
				new CopyFile(LocalSite,Files[0],Files[1]);
			}
			else if(SrcSite instanceof FtpWindow)
			{
				((FtpWindow)SrcSite).copyFile(Files);
			}
		}
		else if(SrcSite == LocalSite)
			((FtpWindow)DestSite).putFile(Files);
		else if(DestSite == LocalSite)
		{
			String NewFile = ((FtpWindow)SrcSite).getFile(Files);
			if(NewFile != null)
				LocalSite.setFileCopied(NewFile);
		}
		else 
		{

			String LocalFile = null;
			try
			{
				File TmpDir = new File(System.getProperty("user.dir"),".ICT");
				if(!TmpDir.exists())
					if(!TmpDir.mkdir())
						throw new FtpProtocolException("Copy Failed\n"+
						"Cannot Make Temporary Directory\n"+TmpDir.getAbsolutePath());

				TreeFtpClient SrcFtp = ((FtpWindow)SrcSite).getFtp();
				synchronized(SrcFtp)
				{
					LocalFile  = SrcFtp.treeGetToDir(Files[0],
					TmpDir.getAbsolutePath());
				}

				String RemFile = null;
				TreeFtpClient DestFtp = ((FtpWindow)DestSite).getFtp();
				synchronized(DestFtp)
				{
					if(Files[1].endsWith(File.separator))
						RemFile = DestFtp.treePutToDir(LocalFile,Files[1]);
					else
						RemFile = DestFtp.treePut(LocalFile,Files[1]);
					DestSite.setFileCopied(RemFile);
				}
			}
			catch(Exception e)
			{
				dispMessage("Copy Failed\n"+
				"From "+Hosts[0]+Files[0]+
				"\nTo "+Hosts[1]+Files[1]);
			}
			if(LocalFile != null)
			{
				try
				{
					(new File(LocalFile)).delete();
				}
				catch(Exception e)
				{
				}
			}
		}
	}

	public void dispMessage(String Msg)
	{
		(new MessageBox(this,MessageBox.OK)).display(Msg);
	}

	public void renFile(String Host,String[] Files)
	{
		//System.out.println(Files[0]+"  "+Files[1]);
		try
		{
			getSite(Host).renFile(Files);
		}
		catch(Exception e)
		{
			dispMessage("Rename Failed.\n"+
			"From: "+ Files[0]+
			"\nTo: "+ Files[1]);
		}
	}
	public void openSite(String Host, String User,
	String Pass, String Dir)
	{
		FtpWindow Ftp = null;
		if(Host == null)
		{
			dispMessage("Invalid Host Name");
			return;
		}
		if(User == null)
		{
			dispMessage("Invalid User Name");
			return;
		}
		try
		{
			showStatus("Opening "+Host+" ...");
			Ftp = new FtpWindow(this,LocalHost,Host,User,
			Pass,Dir);
			Ftp.display();
			addWindow(Ftp);
			showStatus("");
		}
		/*
            catch(UnknownHostException e)
            {
                    dispMessage("Unknown Host "+Host);
            }
            */
		catch(FtpLoginException e)
		{
			dispMessage("Login "+Host+" Failed.\nCheck Username and Password");
		}
		catch(Exception e)
		{
			dispMessage("Cannot open site "+
			Host + "\n"+e.getMessage());
		}

	}
	public void closeSite(String WindowName)
	{
		if(WindowName == "Local Host")
		{
			dispMessage("Cannot close local site");
			return;
		}
		try
		{
			DispWindow Window = null;
			Component[] Comp = WorkSpace.getComponents();
			for(int i=0;i<Comp.length;i++)
				if(((DispWindow)Comp[i]).getTitle() == WindowName)
				{
					Window = (DispWindow)Comp[i];
					break;
				}
			Window.close();
			removeWindow((Component)Window);
		}
		catch(Exception e)
		{
		}
	}

	public Component[] getFtpWindows()
	{
		return WorkSpace.getComponents();
	}
	public void setActiveWindow(DispWindow CurWindow)
	{
		if (ActiveWindow != null)
			ActiveWindow.deselect();
		ActiveWindow = CurWindow;
		ActiveWindow.select();
	}
	public DispWindow getActiveWindow()
	{
		return ActiveWindow;
	}
	public DispWindow getSite(String WindowName)
	{
		Component Comp[] = WorkSpace.getComponents();
		for(int i=0;i<Comp.length;i++)
		{
			if(((DispWindow)Comp[i]).getTitle() == WindowName)
				return((DispWindow)Comp[i]);
		}
		return null;
	}
	public String getSelection(String WindowName)
	{
		Component Comp[] = WorkSpace.getComponents();
		for(int i=0;i<Comp.length;i++)
		{
			if(((DispWindow)Comp[i]).getTitle() == WindowName)
				return(((DispWindow)Comp[i]).getCurSelection());
		}
		return null;
	}
	public void setShowDate(boolean NewState)
	{
		LocalSite.FileList.setShowDate(NewState);
	}
	public void setShowSize(boolean NewState)
	{
		LocalSite.FileList.setShowSize(NewState);
	}

	public boolean getShowDate()
	{
		return LocalSite.FileList.getShowDate();
	}
	public boolean getShowSize()
	{
		return LocalSite.FileList.getShowSize();
	}

	class WorkPanel extends Panel
	{
		public void paint(Graphics g)
		{
			Component Comp[] = getComponents();
			for(int i=0;i<Comp.length;i++)
			{
				Rectangle CompRect = Comp[i].getBounds();
				for(int j=0;j<2;j++)
				{
					g.drawRect(CompRect.x-j,CompRect.y-j,
					CompRect.width+j,CompRect.height+j);
				}
			}
		}
	}


}
