// FileWindow.java 

import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

public class FileWindow extends Panel // implements ActionListener
implements DispWindow
{
	FtpApp Master;
	DirectoryTree FileSystem;
	Label Title;
	Label StatusBar;
	public Font Fpfont;
	Panel CenterPanel;
	TreePanel DirList=null;
	FilePanel FileList=null;
	boolean FormatChanged = false;
	DirectoryTree CurDir;
	String CurSelection = null;

	public FileWindow(FtpApp Master)
	{
		super();
		this.Master = (FtpApp)Master;
		try
		{
			//FileSystem = new DirectoryTree(System.getProperty("user.dir"));
			//FileSystem = new DirectoryTree("/export/home/java/bijoy/prj/tree/tmp1");
			FileSystem = new DirectoryTree(".");
		}
		//catch (DirectorySearchException e)
		catch (Exception e)
		{
			System.out.println("Directory Search Failed");
		}
		CurDir = FileSystem;
		setLayout(new BorderLayout(2,2));
		Fpfont = Master.Fpfont;
		setFont(Fpfont);

		Title = new Label("Local Host",Label.CENTER);
		Title.setFont(new Font("SanSerif",Font.BOLD,Fpfont.getSize()));
		deselect();
		add("North",Title);

		StatusBar = new Label("Started",Label.LEFT);
		add("South",StatusBar);

		DirList = new TreePanel(this);
		//DirList.prepare();
		FileList = new FilePanel(this);
		//FileList.prepare();

		CenterPanel = new Panel();
		CenterPanel.setLayout(new GridLayout(1,2));
		CenterPanel.add(DirList);
		CenterPanel.add(FileList);
		CenterPanel.setVisible(true);
		add("Center",CenterPanel);

		//setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	}
	public void close()
	{
	}

	public void paint(Graphics g)
	{
		Component Comp[] = getComponents();
		for(int i=0;i<Comp.length;i++)
		{
			Rectangle CompRect = Comp[i].getBounds();
			for(int j=0;j<2;j++)
			{
				g.drawRect(CompRect.x-j,CompRect.y-j,
				CompRect.width+j,CompRect.height+j);
			}
		}
	}

	public void display()
	{
		display(FileSystem,false);
	}
	public void display(boolean FilePanelOnly)
	{
		if(FilePanelOnly)
			display(CurDir,true);
		else
			display(FileSystem,false);
	}
	public void display(boolean FormatChanged,boolean FilePanelOnly)
	{
		if(FormatChanged)
			this.FormatChanged = true;
		if(FilePanelOnly)
			display(CurDir,true);
		else
			display(FileSystem,false);
		this.FormatChanged = false;
	}

	public void display(DirectoryTree Root,boolean FilePanelOnly)
	{
		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		TreePanel TmpDirList = new TreePanel(this);
		FilePanel TmpFileList = new FilePanel(this);
		TmpFileList.addTitle(FileList,FormatChanged);
		try
		{
			int MinTokens = new StringTokenizer(Root.Name,File.separator).countTokens();
			if(FilePanelOnly)
				Root = Root.LChild;
			BufferedReader FileTree = Root.readTree();
			String Fname;
			while((Fname = FileTree.readLine())!= null)
			{
				StringTokenizer ST = new StringTokenizer(Fname,
				File.separator);
				int Tokens = ST.countTokens();
				if(Tokens == MinTokens+1)
					TmpFileList.addElement(Fname);
				if(!FilePanelOnly && Fname.endsWith(File.separator))
				{
					String Str = null;
					while(ST.hasMoreElements())
						Str = ST.nextToken();
					if(Str != null)
						TmpDirList.addElement(Fname,Str,Tokens-MinTokens+1);
				}
				//System.out.println("FileWindow: "+Fname+"  "+Tokens+" "+MinTokens);
			}
			FileTree.close();
		}
		catch (NullPointerException e)
		{
			//e.printStackTrace(System.out);
		}
		catch (IOException e)
		{
			//e.printStackTrace(System.out);
		}
		TmpDirList.prepare();
		TmpFileList.prepare();

		if(!FilePanelOnly)
		{
			CenterPanel.remove(DirList);
			CenterPanel.remove(FileList);
			CenterPanel.add(TmpDirList);
			CenterPanel.add(TmpFileList);
			DirList = TmpDirList;
			FileList = TmpFileList;
		}
		else
		{
			CenterPanel.remove(FileList);
			CenterPanel.add(TmpFileList);
			FileList = TmpFileList;
		}

		CenterPanel.invalidate();
		validateTree();

		setCursor(OldCursor);
	}

	public void updateFilePanel(String NewDir)
	{
		try
		{
			FileSystem.getSubTree(FileSystem,NewDir);
			return;
		}
		catch(SubTreeFoundException e)
		{
			CurDir = e.DirTree;
			display(CurDir,true);
		}
	}

	public void CDUP()
	{
		try
		{
			FileSystem = FileSystem.getParentTree();
		}
		catch (Exception e)
		{
			//System.out.println("From CDUP");
			//e.printStackTrace(System.out);
		}
		if(FileSystem == null)
		{
			//System.out.println("Null");
		}
		else
			display(FileSystem,false);
	}

	public void renFile(String Files[])
	{
		if(FileSystem.renameNode(FileSystem,Files[0],Files[1]) == false)
			Master.dispMessage("Rename Failed on Local Site\n"+
			"From: "+Files[0]+
			"\nTo: "+Files[1]);
		else
			setFileRenamed(Files[0]);
	}

	public void deleteNode()
	{
		String Msg = "Please Select the \nFile/Directory to be deleted";
		if(CurSelection == null)
		{
			new MessageBox(Master,MessageBox.OK).display(Msg);
			return;
		}
		if(CurSelection.endsWith(File.separator))
			Msg = "Delete Local Directory\n"+CurSelection;
		else
			Msg = "Delete Local File\n"+CurSelection;
		int Result = (new MessageBox(Master,MessageBox.OK|MessageBox.CANCEL)).display(Msg);
		if(!(Result == MessageBox.OK))
			return;

		Cursor OldCursor = getCursor();
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		if(FileSystem.deleteNode(FileSystem,CurSelection))
			display(true);
		else
			(new MessageBox(Master, MessageBox.OK)).display("Delete Failed\n"+CurSelection);
		setSelection(null);
		setCursor(OldCursor);
	}

	public void dispMessage(String Str)
	{
		(new MessageBox(Master,MessageBox.OK)).display(Str);
	}

	public void setFileRenamed(String NewFile)
	{
		if(!NewFile.startsWith(FileSystem.Name))
			return;
		if(NewFile.startsWith(CurDir.Name))
			display(CurDir,true);
	}
	public void setFileCopied(String NewFile)
	{
		if(!NewFile.startsWith(FileSystem.Name))
			return;
		FileSystem.insertNode(FileSystem,NewFile);
		if(NewFile.startsWith(CurDir.Name))
			display(CurDir,true);
	}

	public void select()
	{
		Title.setBackground(Color.blue);
		Title.setForeground(Color.white);
	}
	public void deselect()
	{
		Title.setBackground(Color.white);
		Title.setForeground(Color.black);
	}
	public String getCurSelection()
	{
		return CurSelection;
	}
	public String getTitle()
	{
		return Title.getText();
	}

	public Font getMasterFont()
	{
		return Fpfont;
	}

	public void showStatus(String status)
	{
		StatusBar.setText(status);
		//Master.showStatus(status);
	}
	public void setSelection(String Selection)
	{
		if(Selection != null)
			StatusBar.setText(Selection);
		else
			StatusBar.setText("");
		CurSelection = Selection;
		Master.setActiveWindow(this);
	}
	public void ascii()
	{
	}
	public void binary()
	{
	}
	public void setMessageWindow(MessageWindow MsgWindow)
	{
	}

}
