// FilePanel.java 

import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;


class FilePanel extends Panel
{
	TitleBox Title;
	Panel FilePane;
	CustomLayout FileLayout;
	public FileMouseAdapter FileMouseListener;
	DispWindow Master;
	Font Fpfont;
	public int DateFieldTab, SizeFieldTab;
	boolean ShowDate = false;
	boolean ShowSize = false;
	int yshift = 2;
	ScrollPane FileScroll;

	public FilePanel(DispWindow Master)
	{
		this.Master = Master;
		Fpfont = Master.getMasterFont();
		setFont(Fpfont);
		setLayout(new BorderLayout());

		FileMouseListener = new FileMouseAdapter(this);
		DateFieldTab = 25 * getCharWidth();
		SizeFieldTab = 45 * getCharWidth();

		FilePane = new Panel();
		FileLayout = new CustomLayout(this,100,300);
		FilePane.setLayout(FileLayout);
		FilePane.setFont(Fpfont);
		FilePane.setForeground(Color.black);
		FilePane.setBackground(Color.white);

		if(!ShowDate && ShowSize)
			SizeFieldTab = DateFieldTab;

		FileScroll = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
		FileScroll.add(FilePane);
		add("Center",FileScroll);
	}
	void addTitle(FilePanel OldPanel,boolean FormatChanged)
	{
		this.ShowDate = OldPanel.ShowDate;
		this.ShowSize = OldPanel.ShowSize;
		if(!FormatChanged)
		{
			DateFieldTab = OldPanel.DateFieldTab;
			SizeFieldTab = OldPanel.SizeFieldTab;
		}
		else if(!ShowDate && ShowSize)
			SizeFieldTab = DateFieldTab;
		Title = new TitleBox(this,ShowDate,ShowSize);
		FilePane.add(Title);
		FileLayout.setShape(Title,1,1,SizeFieldTab*4/getCharWidth()+60,10);
	}
	public void addElement(String Fname)
	{
		int width;
		if(!ShowDate && !ShowSize)
			width = 150;
		else 
			width = ((SizeFieldTab*4)/getCharWidth())+60;
		yshift += 10;
		FileNamePanel FileLabel = new FileNamePanel(this,Fname,
		ShowDate,ShowSize);
		FilePane.add(FileLabel);
		FileLayout.setShape(FileLabel,2,yshift,width,10);
	}

	public void prepare()
	{
		int width;
		if(!ShowDate && !ShowSize)
			width = 150;
		else 
			width = ((SizeFieldTab*4)/getCharWidth())+60;
		FileLayout.setSize(this,width,yshift+20);
		FilePane.setVisible(true);
		setVisible(true);

		FileScroll.getHAdjustable().setBlockIncrement(1+width);
		FileScroll.getHAdjustable().setUnitIncrement(1+width/10);
		FileScroll.getVAdjustable().setBlockIncrement(1+yshift);
		FileScroll.getVAdjustable().setUnitIncrement(1+yshift/10);
	}
	public void paint(Graphics g)
	{
		FileLayout.setShape(Title,1,1,
		FileScroll.getScrollPosition().x+getSize().width,10);
	}

	public void showStatus(String status)
	{
		Master.showStatus(status);
	}
	public void setSelection(String status)
	{
		//Master.showStatus(status);
		Master.setSelection(status);
	}

	public void display()
	{
		Master.display(true);
	}

	public FileMouseAdapter getMouseListener()
	{
		return FileMouseListener;
	}
	protected int getCharWidth()
	{
		FontMetrics m = getFontMetrics(Master.getMasterFont());
		String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		int width = m.stringWidth(s) / s.length();

		if (width <= 0)
			width = 1;
		return width;
	}
	public void setDateTab(int DateTab)
	{
		DateFieldTab = DateTab;
	}
	public void setSizeTab(int SizeTab)
	{
		SizeFieldTab = SizeTab;
	}
	public int getDateTab()
	{
		return DateFieldTab;
	}
	public int getSizeTab()
	{
		return SizeFieldTab;
	}

	public void setShowDate(boolean NewState)
	{
		boolean FormatChanged = true;
		ShowDate = NewState;
		Master.display(FormatChanged,true);
	}
	public void setShowSize(boolean NewState)
	{
		boolean FormatChanged = true;
		ShowSize = NewState;
		Master.display(FormatChanged,true);
	}
	public boolean getShowDate()
	{
		return ShowDate;
	}
	public boolean getShowSize()
	{
		return ShowSize;
	}

}


class FileNamePanel extends Panel
{
	FilePanel Master = null;
	String FileName=null;
	CustomLayout Layout;

	public FileNamePanel(FilePanel Master,String FileName,
	boolean ShowDate,boolean ShowSize)
	{
		super();
		this.Master = Master;
		this.FileName = FileName;
		setFont(Master.Fpfont);
		setForeground(Color.black);
		setBackground(Color.white);

		int dw=0,sw=0;
		if(FileName.endsWith(File.separator))
			FileName = FileName.substring(0,FileName.length()-1);
		if(ShowDate || ShowSize)
		{
			dw = (Master.DateFieldTab*4)/getCharWidth();
			sw = (Master.SizeFieldTab*4)/getCharWidth();
		}
		Layout = new CustomLayout(this,sw+15,10);
		setLayout(Layout);

		File CurFile = new File(FileName);

		if(!ShowDate && !ShowSize)
		{
			String Str = CurFile.getName();
			addLabel(Str,0,Str.length()*4);
			Layout.setSize(this,Str.length()*4,10);
		}
		else if(!ShowDate && ShowSize)
			addLabel(CurFile.getName(),0,sw);
		else
			addLabel(CurFile.getName(),0,dw);
		//addLabel(FileName,0,dw);

		if(ShowDate)
		{
			Date FileDate = new Date(CurFile.lastModified());
			StringBuffer StrBuf = new StringBuffer();
			(new SimpleDateFormat("dd/MM/yy hh:mm:ss")).format(FileDate,
			StrBuf,new FieldPosition(DateFormat.DATE_FIELD));
			addLabel(StrBuf.toString(),dw,sw);
		}

		if(ShowSize)
		{
			String sizestr = Long.toString(CurFile.length());
			addLabel(sizestr,sw,sw+60);
		}
		setVisible(true);
	}

	protected void addLabel(String Str,int start,int end)
	{
		String DispStr = new String(Str);
		int strwidth = (end-start)/4;
		try
		{
			DispStr = DispStr.substring(0,strwidth);
		}
		catch(StringIndexOutOfBoundsException e)
		{
		}
		Label DispLabel = new Label(DispStr, Label.LEFT);
		DispLabel.setFont(Master.Fpfont);

		DispLabel.setForeground(Color.black);
		DispLabel.setBackground(Color.white);

		DispLabel.addMouseListener(Master.getMouseListener());
		add(DispLabel);

		start += (12*4)/getCharWidth();
		Layout.setShape(DispLabel,start,0,end-start,10);
		DispLabel.setVisible(true);
	}
	public void setForeground(Color c)
	{
		for(int i=0;i<getComponentCount();++i)
		{
			Component Comp = getComponent(i);
			Comp.setForeground(c);
		}
	}
	public void setBackground(Color c)
	{
		for(int i=0;i<getComponentCount();++i)
		{
			Component Comp = getComponent(i);
			Comp.setBackground(c);
		}
	}

	public Color getForeground()
	{
		Component l = getComponent(0);
		return l.getForeground();
	}
	public Color getBackground()
	{
		Component l = getComponent(0);
		return l.getBackground();
	}
	public String getText()
	{
		return new String(FileName);
	}


	// Implementation Helpers
	protected int getCharWidth()
	{
		FontMetrics m = getFontMetrics(Master.Fpfont);
		String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		int width = m.stringWidth(s) / s.length();

		if (width <= 0)
			width = 1;
		return width;
	}

	protected int getCharHeight()
	{
		FontMetrics m = getFontMetrics(Master.Fpfont);
		int height = m.getHeight();
		return height;
	}
}

class FileMouseAdapter extends MouseAdapter 
{
	FilePanel Master;
	FileNamePanel NodeSelected=null;
	public FileMouseAdapter(FilePanel Master)
	{
		this.Master = Master;
	}
	public void mouseClicked(MouseEvent evt)
	{
		FileNamePanel l = (FileNamePanel) evt.getComponent().getParent();
		if(NodeSelected != null)
		{
			Color fg = NodeSelected.getForeground();
			Color bg = NodeSelected.getBackground();
			NodeSelected.setForeground(bg);
			NodeSelected.setBackground(fg);
		}
		if(NodeSelected == l)
		{
			NodeSelected = null;
			Master.setSelection(null);
		}
		else
		{
			Color fg = l.getForeground();
			Color bg = l.getBackground();
			l.setForeground(bg);
			l.setBackground(fg);
			Master.setSelection(l.getText());
			NodeSelected = l;
		}
	}
}
