//DirectoryTree.java

import java.io.*;
import java.util.*;
class DirectorySearchException extends java.lang.Exception
{
	private DirectoryTree DirTree=null;
	DirectorySearchException(DirectoryTree DT)
	{
		DirTree = DT;
	}
	public void terminateSearch()
	{
		DirTree.finished = true;
	}
}



//New exception to handle errors in directory search.

public class DirectoryTree extends File
implements Runnable, Cloneable
{

	public DirectoryTree LChild = null; 
	// First child
	public DirectoryTree RChild = null; 
	// Link to remaining children
	protected static int NumNodes = 0;  
	// Count the number of nodes

	DirectoryTree TraversedSubTree = null;

	//Siblings to the right of the current node
	String[] Siblings = null;

	//the printing thread checks for this flag before proceeding
	boolean finished = false;

	//Name of the file
	String Name = null;

	// Access method for number of nodes
	public int getNumNodes()
	{
		return NumNodes;
	}

	public DirectoryTree()
	{
		super("dummy");
	}
	public DirectoryTree(String Node,boolean Finished)
	{
		super(new File(Node).getAbsolutePath());
		this.Name = new File(Node).getAbsolutePath();
		this.finished = Finished;
	}
	// Constructor, for a node with no siblings to right 
	public DirectoryTree(String Node)
	//throws DirectorySearchException
	throws Exception
	{
		this(null,Node,null);
	}
	public DirectoryTree(DirectoryTree DT,String Node)
	//throws DirectorySearchException
	throws Exception
	{
		this(DT,Node,null);
	}

	public DirectoryTree(DirectoryTree DT, String Node, String[] Siblings)
	// throws DirectorySearchException
	throws Exception
	{
		// Call super class constructor with absolute path
		//super(new File(Node).getAbsolutePath());
		super(new File(Node).getCanonicalPath());
		Name = new File(Node).getCanonicalPath();
		TraversedSubTree = DT;

		// Increment number of nodes
		++NumNodes;
		this.Siblings = Siblings;
		if(!exists())
			throw new DirectorySearchException(this);
		new Thread(this).start();
	}

	public synchronized void run()
	{
		//System.out.println(NumNodes+" : "+getAbsolutePath());
		try
		{
			// Add left child for a directory
			// Ignore the children if read is not allowed
			if(isDirectory())
			{
				boolean LChildProcessed = false;
				if(! Name.endsWith(File.separator))
					Name += File.separator;
				if(TraversedSubTree!=null)
				{
					if(Name.equals(TraversedSubTree.Name))
					{
						LChild = TraversedSubTree.LChild;
						TraversedSubTree = null;
						LChildProcessed = true;
					}
				}
				if((!LChildProcessed) && canRead())
				{
					// Get the directory listing
					String[] DirList = list();

					// The arraycopy will throw exception if 
					// length of list is zero.
					if(DirList.length>0)
					{
						for(int i=0;i<DirList.length;i++)
							DirList[i] = 
							new File(this,DirList[i]).getAbsolutePath();
						String Child = DirList[0];
						String[] Siblgs = new String[DirList.length-1];
						System.arraycopy(DirList,1,Siblgs,0,Siblgs.length);

						// Create a left child
						LChild = new DirectoryTree(TraversedSubTree,Child,Siblgs);
						// Start a new thread to process the subdirectory
					}
				}
			}

			// Add siblings to the right
			if(Siblings!=null)
			{
				// Arraycopy will throw exception if length
				// of the string is less than two.
				if(Siblings.length>1)
				{
					String Child = Siblings[0];
					String[] Siblgs = new String[Siblings.length-1];
					System.arraycopy(Siblings,1,Siblgs,0,Siblgs.length);

					// Create new thread to process the remaining
					// siblings and start it
					RChild = new DirectoryTree(TraversedSubTree,Child,Siblgs);
				}
				// this is the last sibling
else if (Siblings.length == 1)
{
	RChild = new DirectoryTree(TraversedSubTree,Siblings[0]);
}
			}
		}

		// Catch the search exception during subtree search and
		// terminate the thread which raised the exception.
		catch(DirectorySearchException e)
		{
			e.terminateSearch();
		}

		// General exception handler.
		// Print the error message and continue.
		catch(Exception e)
		{
			//System.out.println(e.toString() + Thread.currentThread());
			//e.printStackTrace(System.out);
		}

		// Set the finished flag to true so that other threads
		// can  process the node
		finished = true;
		Siblings = null;
	}

	public DirectoryTree getParentTree()
	//throws DirectorySearchException
	throws Exception
	{

		String Str = Name;
		if(Str.endsWith(File.separator))
			Str = Str.substring(0,(Str.lastIndexOf(File.separator)));
		Str = Str.substring(0,Str.lastIndexOf(File.separator));
		return (new DirectoryTree(this,Str,null));
	}

	public DirectoryTree getSubTree(DirectoryTree DT,String NodeName)
	throws SubTreeFoundException
	{
		if(DT == null)
			return null;
		if(DT.Name.equals(NodeName))
			throw new SubTreeFoundException(DT);
		getSubTree(DT.RChild,NodeName);
		getSubTree(DT.LChild,NodeName);
		return null;
	}


	public BufferedReader readTree()
	throws IOException
	{
		PipedWriter PW = new PipedWriter();
		PipedReader PR = new PipedReader(PW);
		new TreePrinter(this,PW);
		return (new BufferedReader(PR));
	}

	// Print the tree. Recursive function
	// Pre-order traversal of the binary tree will give the 
	// directory tree as it is.
	static void printTree(DirectoryTree Root, PrintWriter Out)
	{
		// Terminating condition
		if(Root == null)
			return;

		// Wait until the node is constructed properly.
		while(Root.finished == false)
			Thread.yield();
		Out.println(Root.Name);

		printTree(Root.LChild,Out);
		printTree(Root.RChild,Out);
	}

	public static boolean renameNode(DirectoryTree Root,
	String OldName, String NewName)
	{
		File OldFile = new File(OldName);
		if(OldFile.renameTo(new File(NewName)))
		{
			try
			{
				Root.getSubTree(Root,OldName);
				return false;
			}
			catch(SubTreeFoundException e)
			{
				e.DirTree.Name = NewName;
				return true;
			}
		}
		return false;
	}

	public static boolean deleteNode(DirectoryTree Root,String NodeName)
	{
		//System.out.println("deleteNode:"+NodeName);
		String TmpName = new String(NodeName);
		if(TmpName.endsWith(File.separator))
			TmpName = TmpName.substring(0,
			(TmpName.lastIndexOf(File.separator)));
		TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator))+1);
		//System.out.println("TmpName1 = "+TmpName);
		try
		{
			Root.getSubTree(Root,TmpName);
			//System.out.println("Subtree search failed");
			return false;
		}
		catch(SubTreeFoundException e)
		{
			TmpName = new String(NodeName);
			if(TmpName.endsWith(File.separator))
				TmpName = NodeName.substring(0,
				(NodeName.lastIndexOf(File.separator)));
			//System.out.println("TmpName2 = "+TmpName);
			File NodeFile = new File(TmpName);
			try
			{
				if(NodeFile.delete())
				{
					if(e.DirTree.LChild.Name.equals(NodeName))
						e.DirTree.LChild = e.DirTree.LChild.RChild;
					else 
					{
						DirectoryTree TmpTree = new DirectoryTree();
						;
						TmpTree = e.DirTree.LChild;
						boolean Finished = false;
						while(! Finished)
						{
							if(TmpTree.RChild.Name.equals(NodeName))
							{
								TmpTree.RChild = TmpTree.RChild.RChild;
								Finished = true;
							}
							else
								TmpTree = TmpTree.RChild;
						}
					}
					//System.out.println("Deleted");
					return true;
				}
				else 
					return false;
			}
			catch(Exception e1)
			{
				return false;
			}
		}
	}


	public static boolean insertNode(DirectoryTree Root,String NodeName)
	{
		DirectoryTree NewNode = new DirectoryTree(NodeName,true);
		if(!insertNode(Root,NewNode))
		{
			String TmpName = new String(NodeName);
			if(TmpName.endsWith(File.separator))
				TmpName = TmpName.substring(0,
				(TmpName.lastIndexOf(File.separator)));
			TmpName = TmpName.substring(0,
			(TmpName.lastIndexOf(File.separator))+1);
			insertNode(Root,TmpName);
			insertNode(Root,NodeName);
		}
		return(true);
	}

	public static boolean insertNode(DirectoryTree Root,DirectoryTree NewNode)
	{
		String NodeName = NewNode.Name;
		//System.out.println("insertNode:"+NodeName);
		String TmpName = new String(NodeName);
		if(TmpName.endsWith(File.separator))
			TmpName = TmpName.substring(0,
			(TmpName.lastIndexOf(File.separator)));
		TmpName = TmpName.substring(0,(TmpName.lastIndexOf(File.separator))+1);
		//System.out.println("TmpName1 = "+TmpName);
		try
		{
			Root.getSubTree(Root,TmpName);
			//System.out.println("Subtree search failed");
			return false;
		}
		catch(SubTreeFoundException e)
		{
			try
			{
				if(e.DirTree.LChild == null)
					e.DirTree.LChild = NewNode;
				else if(NodeName.compareTo(e.DirTree.LChild.Name)<0)
				{
					NewNode.RChild = e.DirTree.LChild;
					e.DirTree.LChild = NewNode;
				}
				else 
				{
					DirectoryTree TmpTree = e.DirTree.LChild;
					boolean Finished = false;
					while(! Finished)
					{
						if(TmpTree.RChild == null)
						{
							TmpTree.RChild = NewNode;
							Finished = true;
						}
						else if(NodeName.compareTo(TmpTree.RChild.Name)<0)
						{
							NewNode.RChild = TmpTree.RChild;
							TmpTree.RChild = NewNode;
							Finished = true;
						}
						else
							TmpTree = TmpTree.RChild;
					}
				}
				//System.out.println("Inserted");
				return true;
			}
			catch(Exception e1)
			{
				return false;
			}
		}
	}

	public static void main(String args[])
	throws Exception
	{
		DirectoryTree Root = 
		new DirectoryTree(System.getProperty("user.dir"));
		//new Thread(Root).start();

		// Start the resource monitor
		new ResourceMonitor();
		BufferedReader BR = Root.readTree();
		String Str;
		while((Str = BR.readLine()) !=null)
			System.out.println("From Main:"+Str);
	}

}

class TreePrinter extends Thread
{
	DirectoryTree Root;
	PipedWriter PW;
	PrintWriter Printer;
	TreePrinter(DirectoryTree Root,PipedWriter PW)
	{
		this.Root = Root;
		this.PW = PW;
		Printer = new PrintWriter(PW);
		start();
	}

	public void run()
	{
		Root.printTree(Root,Printer);
		Printer.close();
	}
}
