// CopyFile.java beautified on Sat Oct 4 15:10:33 IST 1997
// CopyFile.java - copy a file from source to destination 
import java.io.*;
interface BufferStatus
{
	public final static int Empty = 0;
	public final static int Full = 1;
	public final static int bufSize = 1024;
}
class Buffer implements BufferStatus
{
	byte data[] = new byte[bufSize];
	public int status = Empty;

	volatile int dataLength;
	Buffer Next;

	Buffer()
	{
		dataLength = 0;
		Next = null;
	}
	public synchronized Buffer produce(FileInputStream Fin)
	throws IOException
	{
		dataLength = Fin.read(data);
		//System.out.println("Reading Data : Length = "+dataLength);
		if(dataLength == data.length)
			Next = new Buffer();
		status = Full;
		notify();
		return(Next);
	}

	public synchronized Buffer consume(FileOutputStream Fout)
	throws IOException
	{
		try
		{
			while(status == Empty)
				wait();
		}
		catch(Exception e)
		{
		}
		//System.out.println("Writing data : Length = "+dataLength);
		Fout.write(data,0,dataLength);
		return(Next);
	}
}

class Producer extends FileInputStream implements Runnable
{
	Buffer Buf;
	CopyFile Master;
	Producer(CopyFile Master,String fname, Buffer b)
	throws IOException
	{
		super(fname);
		this.Master = Master;
		Buf = b;
	}
	public void run ()
	{
		boolean Finished = true;
		try
		{
			while((Buf = Buf.produce(this)) != null)
				Thread.yield();
		}
		catch(IOException e)
		{
			Finished = false;
		}
		finally
		{
			Master.terminate(Finished);
		}
	}
}

class Consumer extends FileOutputStream implements Runnable
{
	Buffer Buf;
	CopyFile Master;
	Consumer( CopyFile Master,String fname, Buffer b)
	throws IOException
	{
		super(fname);
		this.Master = Master;
		Buf = b;
	}
	public void run ()
	{
		boolean Finished = true;
		try
		{
			while((Buf = Buf.consume(this)) != null)
				Thread.yield();
		}
		catch(IOException e)
		{
			Finished = false;
		}
		finally
		{
			Master.terminate(Finished);
		}
	}
}
public class CopyFile 
{
	Buffer Buf = new Buffer();
	String SrcFile,DestFile;
	Thread ProdThr,ConsThr;
	FileWindow Master;
	int FinishedThreadCount = 0;

	public CopyFile(FileWindow Master, String Src, String Dest)
	{
		this.Master = Master;
		SrcFile = Src;
		DestFile = Dest;

		try
		{
			ProdThr = new Thread(new Producer(this,SrcFile,Buf));
			ConsThr = new Thread(new Consumer(this,DestFile,Buf));
			ProdThr.start();
			ConsThr.start();
		}
		catch(Exception e)
		{
			//System.out.println("Exception raised");
		}
	}
	public static void main(String[] args)
	{
		if(args.length != 2)
		{
			System.out.println("Usage: java CopyFile sfile dfile");
			System.exit(1);
		}
		new CopyFile(null,args[0],args[1]);

	}

	public synchronized void terminate(boolean Finished)
	{
		if (Finished == true)
		{
			FinishedThreadCount++;
			//System.out.println("Terminate called");
			if(FinishedThreadCount==2)
			{
				Master.setFileCopied(DestFile);
				//System.out.println("Finished");
			}
		}
		else
		{
			if(ProdThr.isAlive())
				ProdThr.destroy();
			if(ConsThr.isAlive())
				ConsThr.destroy();
			Master.dispMessage("Copy Operation Failed\nFrom  "
			+SrcFile+"\nTo  "+DestFile );
			//System.out.println("Not Finished, Threads stopped");
		}
	}


}
