import java.io.*;
import java.net.*;
import java.util.*;

public class JMPF
{
   Hashtable groupids = new Hashtable();
   Hashtable portids = new Hashtable();

   PrintStream to_server = null;
   DataInputStream from_server = null;

   int job_id = 0;
   String hostname = "";
   int host_id = 0;

   String loc_group_hostname = "";
   String loc_port_hostname = "";
   int loc_group_hostid = 0;
   int loc_port_hostid = 0;
   String servername = "";

   public JMPF(int jobid, int task_id)
   {
      Socket for_hostname = null;
      init_comm();

      job_id = jobid;
      hostname = read_hostname();
      host_id = task_id;
      System.out.println("...constructor hostname is : " + hostname);
      System.out.println("...constructor hostid is : " + host_id);

      try
      {
         for_hostname = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in opening socket " + e);
      }

      try
      {
         to_server = new PrintStream(for_hostname.getOutputStream());
         from_server = new DataInputStream(for_hostname.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("hostname");
      to_server.println(job_id);
      to_server.println(hostname);
      to_server.println(host_id);
      to_server.println("add");
   }

   public void init_comm()
   {
      String str = "";
      int i = 0;
      FileInputStream fin = null;

      try
      { 
         fin = new FileInputStream("java.hpc");
      }
      catch (IOException e)
      {
         System.out.println("Error in openning Streams in sendfile:" + e);
      }

      try
      {
         do
         {
            i = fin.read();
            if (i != -1)
               str = str + (char)i;
         }
         while (i != -1);
//       System.out.println("Servername is " + str);
      }
      catch (IOException e)
      {
         System.out.println("File error" + e);
      }
      servername = str;
   }

   public String read_hostname()
   {
      InetAddress Address = null;
      try
      {
         Address = InetAddress.getLocalHost();
      }
      catch(UnknownHostException e)
      {
         System.out.println("host : " + e);
      }

      String host_name = Address.getHostName();
      return(host_name);
   }

   public int CreatePortGroup(String name)
   {
      ServerSocket create_socket = null;
      Socket for_createport = null;
      int group_id = 0;

      int status = LocatePortGroup(name);

      if ((status == 0) || (status == -1)) 
      {
         try
         {
            create_socket  = new ServerSocket(0);
         }
         catch (IOException e)
         {
            System.out.println("error in create port is : " + e);
         }
         group_id = create_socket.getLocalPort();

         try
         {
            for_createport = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket " + e);
         }
         try
         {
            to_server = new PrintStream(for_createport.getOutputStream());
            from_server = new DataInputStream(for_createport.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams " + e);
         }
         to_server.println("createport_group");
         to_server.println(job_id);
         to_server.println(hostname);
         to_server.println(host_id);
         to_server.println(name);
         to_server.println(group_id);

         groupsocket obj = new groupsocket(name, group_id, create_socket);
         groupids.put(name, obj);
      }

      else if ((status != 0) || (status != -1))
      {
         if (status == 0)
            group_id = -1;
         else if (status == -1)
            group_id = 0;
      }
      return(group_id);
   }

   public int CreatePort(String name)
   {
      ServerSocket create_socket = null;
      Socket for_createport = null;
      int port_id = 0;

      int status = LocatePort(name);

      if ((status == 0) || (status == -1))
      {
         try
         {
            create_socket  = new ServerSocket(0);
         }
         catch (IOException e)
         {
            System.out.println("error in create port is : " + e);
         }
         port_id = create_socket.getLocalPort();

         try
         {
            for_createport = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket " + e);
         }
         try
         {
            to_server = new PrintStream(for_createport.getOutputStream());
            from_server = new DataInputStream(for_createport.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams " + e);
         }
         to_server.println("createport");
         to_server.println(job_id);
         to_server.println(hostname);
         to_server.println(host_id);
         to_server.println(name);
         to_server.println(port_id);

         portsocket obj = new portsocket(name, port_id, create_socket);
         portids.put(name, obj);
      }
      else if ((status != 0) || (status != -1))
      {
         if (status == 0)
            port_id = -1;
         else if (status == -1)
            port_id = 0;
      }
      return(port_id);
   }

   public int AddMember(String gp_name, int pt_no)
   {
      int status = 0;
      Socket for_createport = null;

      int group_id = LocatePortGroup(gp_name);
      if (group_id == 0)
         status = 0;
      else if (group_id == -1)
         status = -1;
      else
      {
         try
         {
            for_createport = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket " + e);
         }
         try
         {
            to_server = new PrintStream(for_createport.getOutputStream());
            from_server = new DataInputStream(for_createport.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams " + e);
         }
         to_server.println("add_member");
         to_server.println(job_id);
         to_server.println(gp_name);
         to_server.println(pt_no);
         try
         {
            status = Integer.parseInt(from_server.readLine());
         }
         catch (IOException e)
         {
            System.out.println("Cre..Error in reading from server " + e);
         }
      }
      return(status);
   }

   public int LocatePortGroup(String name)
   {
      int group_id = 0;
      Socket for_locateport = null;

      try
      {
         for_locateport = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in connecting to server " + e);
      }
      try
      {
         to_server = new PrintStream(for_locateport.getOutputStream());
         from_server = new DataInputStream(for_locateport.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("locateport_group");
      to_server.println(job_id);
      to_server.println(name);
      try
      {  
         loc_group_hostname = from_server.readLine();
         loc_group_hostid = Integer.parseInt(from_server.readLine());
         group_id = Integer.parseInt(from_server.readLine());
      }
      catch (IOException e)
      {
         System.out.println("Loc..Error in reading from server " + e);
      }

      return(group_id);
   }

   public int LocatePortGroup(String name, boolean flag)
   {
      int group_id;
      if (flag == true)
      {
         while (true)
         {
            group_id = LocatePortGroup(name);
            if (group_id > 0)
               break;
        }
      }
      else
      {
         group_id = LocatePortGroup(name);
      }

      return(group_id);
   }

   public int LocatePort(String name)
   {
      int portno = 0;
      Socket for_locateport = null;

      try
      {
         for_locateport = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in connecting to server " + e);
      }
      try
      {
         to_server = new PrintStream(for_locateport.getOutputStream());
         from_server = new DataInputStream(for_locateport.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("locateport");
      to_server.println(job_id);
      to_server.println(name);
      try
      {
         loc_port_hostname = from_server.readLine();
         loc_port_hostid = Integer.parseInt(from_server.readLine());
         portno = Integer.parseInt(from_server.readLine());
      }
      catch (IOException e)
      {
         System.out.println("Loc..Error in reading from server " + e);
      }

      return(portno);
   }

   public int LocatePort(String name, boolean flag)
   {
      int port_id;
      if (flag == true)
      {
         while (true)
         {
            port_id = LocatePort(name);
            if (port_id > 0)
               break;
        }
      }  
      else
      {   
         port_id = LocatePort(name);
      }

      return(port_id);
   }

   public Vector ShowStatus(String gp_name)
   {
      Socket for_showstatus = null;
      Vector vector = new Vector(1, 1);
      int portno = 0;
 
      try
      {
         for_showstatus = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in connecting to server " + e);
      }
      try
      {  
         to_server = new PrintStream(for_showstatus.getOutputStream());
         from_server = new DataInputStream(for_showstatus.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("show_status");
      to_server.println(job_id);
      to_server.println(gp_name);
      while (portno != -3)
      {
         try
         {  
            portno = Integer.parseInt(from_server.readLine());
            if (portno == -3)
               continue;
            vector.addElement(new Integer(portno));
         }
         catch (IOException e)
         {
            System.out.println("Show..Error in reading from server " + e);
         }
      }   
      return(vector);
   }

   public int DeletePortGroup(String name)
   {
      int portno = 0;
      Socket for_deleteport = null;
      ServerSocket sk;

      try
      {
         for_deleteport = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in making socket connection " + e);
      }
      try
      {
         to_server = new PrintStream(for_deleteport.getOutputStream());
         from_server = new DataInputStream(for_deleteport.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("deleteport_group");
      to_server.println(job_id);
      to_server.println(name);
      try
      {
         portno = Integer.parseInt(from_server.readLine());
      }
      catch (IOException e)
      {
         System.out.println("Del..Error in reading from server " + e);
      }
      if ((portno != -1) && (portno != 0))
      {
         groupsocket obj = (groupsocket)groupids.get(name);
         sk = obj.serversocket;
         try
         {
            sk.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }
         groupids.remove(name);
      }

/*      if (portno == 0)
         System.out.println("The table is empty... Cannot delete : " + name);
      else if (portno == -1)
         System.out.println("The port does not exists by name : " + name);
      else
         System.out.println("The port is deleted by name : "+name+":"+portno);
*/
      return(portno);
   }

   public int DeletePort(String name)
   {
      int portno = 0;
      Socket for_deleteport = null;
      ServerSocket sk;

      try
      {
         for_deleteport = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in making socket connection " + e);
      }
      try
      {
         to_server = new PrintStream(for_deleteport.getOutputStream());
         from_server = new DataInputStream(for_deleteport.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("deleteport");
      to_server.println(job_id);
      to_server.println(name);
      try
      {
         portno = Integer.parseInt(from_server.readLine());
      }
      catch (IOException e)
      {
         System.out.println("Del..Error in reading from server " + e);
      }
      if ((portno != 0) && (portno != -1))
      {
         portsocket obj = (portsocket)portids.get(name);
         sk = obj.serversocket;
         try
         {
            sk.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }
         portids.remove(name);
      }

/*      if (portno == 0)
         System.out.println("The table is empty... Cannot delete : " + name);
      else if (portno == -1)
         System.out.println("The port does not exists by name : " + name);
      else
         System.out.println("The port is deleted by name : "+name+":"+portno);
*/
      return(portno);
   }

   public int RemoveMember(String gp_name, int pt_no)
   {
      int portno = 0;
      Socket for_remove = null;

      try
      {
         for_remove = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in opening socket " + e);
      }
      try
      {
         to_server = new PrintStream(for_remove.getOutputStream());
         from_server = new DataInputStream(for_remove.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("remove_member");
      to_server.println(job_id);
      to_server.println(gp_name);
      to_server.println(pt_no);
      try
      {
//         portno = Integer.valueOf(from_server.readLine()).intValue();
         portno = Integer.parseInt(from_server.readLine());
      }
      catch (IOException e)
      {
         System.out.println("Rem..Error in reading from server " + e);
      }

/*      if (portno == -1)
         System.out.println("The port already exists by name :" + name);
      else
         System.out.println("The port is created by name : " + name);
*/
      return(portno);
   }

   synchronized public int SyncsendGroup(String gp_name, String message)
   {
      int status = 0;
      Vector vector = ShowStatus(gp_name);
//      Vector h_vector = names_of_hosts(gp_name);
      
      for (int i = 0; i < vector.size(); i++)
      {
         status = Send(((Integer)vector.elementAt(i)).intValue(), message);
      }
      return(status);
   } 

   synchronized public int SyncsendGroup(String gp_name, char[] message)
   {
      int status = 0;
      Vector vector = ShowStatus(gp_name);
//      Vector h_vector = names_of_hosts(gp_name);

      for (int i = 0; i < vector.size(); i++)
      {
         status = Send(((Integer)vector.elementAt(i)).intValue(), message);
      }
      return(status);
   }

   synchronized public int SyncsendGroup(String gp_name, int message)
   {
      int status = 0;
      Vector vector = ShowStatus(gp_name);
//      Vector h_vector = names_of_hosts(gp_name);

      for (int i = 0; i < vector.size(); i++)
      {
         status = Send(((Integer)vector.elementAt(i)).intValue(), message);
      }
      return(status);
   }

   synchronized public String BlockReceive(int port_id, String st)
   {
      String str = Receive(port_id, st); 
      return(str);
   }

   synchronized public int BlockReceive(int port_id, int it)
   {
      int value = Receive(port_id, it);
      return(value);
   }

   synchronized public String BlockReceive(int port_id, char[] st)
   {
      String str = Receive(port_id, st);
      return(str);
   }

   synchronized public String BlockReceiveString(int port_id)
   {
      String str = ReceiveString(port_id);
      return(str);
   }

   synchronized public int BlockReceiveInt(int port_id)
   {
      int value = ReceiveInt(port_id);
      return(value);
   }

   synchronized public char[] BlockReceiveCharArray(int port_id)
   {
      return(ReceiveCharArray(port_id));
   }                

   synchronized public PrintStream CreatePS(int portno)
   {  
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      Socket connect_socket = null;
      String str = "";
      int ptno = 0;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   

      if (receive_socket == null)
      {
// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }
         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }
   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         return(to_pgm);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         return(to_pgm);
      }
   }

   public int Send(int portno, int message)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";
      int value = -1;
      Socket connect_socket = null;
      int status = 0;
      int ptno;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   

      if (receive_socket == null)
      {
// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }
         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }
   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         to_pgm.println(message);
         try
         {  
            status = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("sen1..Error in reading from the Streams :" + e);
         }
 
         try
         {  
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }
         return(status);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         to_pgm.println(message);
         try
         {  
            status = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("sen1..Error in reading from the Streams :" + e);
         }

         try
         {  
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(status);
      }
   }
   
   synchronized public int Send(int portno, String message)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";
      int value = -1;
      Socket connect_socket = null;
      int status = 0;
      int ptno;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   

      if (receive_socket == null)
      {
// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }
         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }
   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         to_pgm.println(message);
         try
         {  
            status = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("sen1..Error in reading from the Streams :" + e);
         }
 
         try
         {  
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }
         return(status);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         to_pgm.println(message);
         try
         {  
            status = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("sen1..Error in reading from the Streams :" + e);
         }

         try
         {  
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(status);
      }
   }

   synchronized public int Send(int portno, char[] message)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";
      Socket connect_socket = null;
      int status = 0;
      int ptno = 0;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   

      if (receive_socket == null)
      {
// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }
         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }
   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         String s = new String(message);
 
         to_pgm.println(s.length());
         to_pgm.print(message);
         try
         {
            status = Integer.parseInt(from_pgm.readLine());
         }

         catch (IOException e)
         {
            System.out.println("sen1..Error in reading from the Streams :" + e);
         }
 
         try
         {  
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }
         return(status);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         String s = new String(message);
 
         to_pgm.println(s.length());
         to_pgm.print(message);
         try
         {
            status = Integer.parseInt(from_pgm.readLine());
         }

         catch (IOException e)
         {
            System.out.println("sen1..Error in reading from the Streams :" + e);
         }

         try
         {  
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(status);
      }
   }

   synchronized public int Send(PrintStream pos, int message)
   {
      pos.println(message);
      return(1);
   }
      
   synchronized public int Send(PrintStream pos, String message)
   {
      pos.println(message);
      return(1);
   }
      

   synchronized public int Send(PrintStream pos, char[] message)
   {
      String s = new String(message);

      pos.println(s.length());
      pos.print(message);
      return(1);
   }

   synchronized public DataInputStream CreateDIS(int portno)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      Socket connect_socket = null;
      String str = "";
      int ptno = 0;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   

      if (receive_socket == null)
      {
// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }
         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }
   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }
         return(from_pgm);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         return(from_pgm);
      }
   }

   public int Receive(int portno, int message)
   {
      ServerSocket receive_socket = null;
      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";
      int value = -1;
      int ptno;
      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   
      if (receive_socket == null)
      {
         Socket connect_socket = null;
         int status = 0;

// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }

         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }

   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         try
         {  
            value = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (value == -1)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {  
//         receive_socket.close();
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(value);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);     }

         try
         {  
            value = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (value == -1)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {  
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(value);
      }
   }
      
   synchronized public String Receive(int portno, String st)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";

      int ptno;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   
      if (receive_socket == null)
      {
         Socket connect_socket = null;
         int status = 0;

// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }

         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }

   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         try
         {  
            str = from_pgm.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {  
//         receive_socket.close();
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);     }

         try
         {  
            str = from_pgm.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {  
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str);
      }
   }
      
   synchronized public String Receive(int portno, char[] st)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";

      int ptno;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }   
      if (receive_socket == null)
      {
         Socket connect_socket = null;
         int status = 0;

// -----------------------------------------
         Socket for_send = null;

         try
         {  
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {  
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }

         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {  
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }

   //-----------------------------------------
         try
         {  
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {  
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         try
         {  
            int len = Integer.parseInt(from_pgm.readLine());

            byte by[] = new byte[len];
            from_pgm.readFully(by);
            str = new String(by, len);
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {  
//         receive_socket.close();
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str);
      }

      else
      {
// ---------------------------------------
         try
         {  
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         try
         {  
            int len = Integer.parseInt(from_pgm.readLine());

            byte by[] = new byte[len];
            from_pgm.readFully(by);
            str = new String(by, len);
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {  
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str);
      }
   }

   public int ReceiveInt(int portno)
   {
      ServerSocket receive_socket = null;
      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";
      int value = -1;
      int ptno;
      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }
      if (receive_socket == null)
      {                                                                        
         Socket connect_socket = null;
         int status = 0;

// -----------------------------------------
         Socket for_send = null;

         try
         {
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }                                                                     
         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }

   //-----------------------------------------
         try
         {
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {                                                                     
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         try
         {
            value = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (value == -1)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try                                                                   
         {
//         receive_socket.close();
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(value);
      }

      else
      {
// ---------------------------------------
         try
         {
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);     }

         try
         {
            value = Integer.parseInt(from_pgm.readLine());
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (value == -1)
            to_pgm.println(-1);
         else
            to_pgm.println(1);
         try
         {
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(value);
      }
   }

   synchronized public String ReceiveString(int portno)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";
      int ptno;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }
      if (receive_socket == null)
      {
         Socket connect_socket = null;
         int status = 0;

// -----------------------------------------
         Socket for_send = null;

         try
         {
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }

         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }

   //-----------------------------------------
         try
         {
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         try
         {
            str = from_pgm.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {
//         receive_socket.close();
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str);
      }

      else
      {
// ---------------------------------------
         try
         {
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);     }

         try
         {
            str = from_pgm.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str);
      }
   }

   synchronized public char[] ReceiveCharArray(int portno)
   {
      ServerSocket receive_socket = null;

      Socket accept_socket = null;
      DataInputStream from_pgm = null;
      PrintStream to_pgm = null;
      String str = "";

      int ptno;

      Enumeration names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();
         portsocket obj = (portsocket)portids.get(str);
         ptno = obj.portid;

         if (ptno ==  portno)
         {
            receive_socket = obj.serversocket;
         }
      }
      if (receive_socket == null)
      {
         Socket connect_socket = null;
         int status = 0;

// -----------------------------------------
         Socket for_send = null;

         try
         {
            for_send = new Socket(servername, 4578);
         }
         catch (IOException e)
         {
            System.out.println("Error in opening socket connection " + e);
         }
         try
         {
            to_server = new PrintStream(for_send.getOutputStream());
            from_server = new DataInputStream(for_send.getInputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams" + e);
         }

         to_server.println("where_to_send");
         to_server.println(job_id);
         to_server.println(portno);
         try
         {
            hostname = from_server.readLine();
         }
         catch (IOException e)
         {
            System.out.println("rec..Error in reading from server " + e);
         }
   //-----------------------------------------
         try
         {
            connect_socket = new Socket(hostname, portno);
         }
         catch (IOException e)
         {
            System.out.println("Error in making connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(connect_socket.getInputStream());
            to_pgm = new PrintStream(connect_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in opening streams int receive:" + e);
         }

         try
         {
            int len = Integer.parseInt(from_pgm.readLine());

            byte by[] = new byte[len];
            from_pgm.readFully(by);
            str = new String(by, len);
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {
//         receive_socket.close();
            connect_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str.toCharArray());
      }

      else
      {
// ---------------------------------------
         try
         {
            accept_socket = receive_socket.accept();
         }
         catch (IOException e)
         {
            System.out.println("Error in accepting connection :" + e);
         }
         try
         {
            from_pgm = new DataInputStream(accept_socket.getInputStream());
            to_pgm = new PrintStream(accept_socket.getOutputStream());
         }
         catch (IOException e)
         {
            System.out.println("Error in openning Streams in send:" + e);
         }

         try
         {
            int len = Integer.parseInt(from_pgm.readLine());

            byte by[] = new byte[len];
            from_pgm.readFully(by);
            str = new String(by, len);
         }
         catch (IOException e)
         {
            System.out.println("rec2..Error in reading :" + e);
         }

         if (str == null)
            to_pgm.println(-1);
         else
            to_pgm.println(1);

         try
         {
//         receive_socket.close();
            accept_socket.close();
         }
         catch (IOException e)
         {
            System.out.println("Error in closing the sockets :" + e);
         }

         return(str.toCharArray());
      }
   }                                                                           

   synchronized public int Receive(DataInputStream dis, int it)
   {
      int value = 0;
      try
      {
         value = Integer.parseInt(dis.readLine());
      }
      catch (IOException e)
      {
         System.out.println("rec2..Error in reading :" + e);
      }
      return(value);
   }

   synchronized public String Receive(DataInputStream dis, String st)
   {
      String str = "";
      try
      {
         str = dis.readLine();
      }
      catch (IOException e)
      {                                                                                System.out.println("rec2..Error in reading :" + e);
      }

      return(str);
   }

   synchronized public String Receive(DataInputStream dis, char[] st)
   {
      String str = "";
      try
      {
         int len = Integer.parseInt(dis.readLine());

         byte by[] = new byte[len];
         dis.readFully(by);
         str = new String(by, len);
      }
      catch (IOException e)
      {
         System.out.println("rec2..Error in reading :" + e);
      }

      return(str);                                                              
   }

   synchronized public int ReceiveInt(DataInputStream dis) 
   {
      int value = 0;
      try
      {  
         value = Integer.parseInt(dis.readLine());
      }
      catch (IOException e)
      {
         System.out.println("rec2..Error in reading :" + e);
      }
      return(value);
   }

   synchronized public String ReceiveString(DataInputStream dis)
   {
      String str = "";
      try
      {
         str = dis.readLine();
      }
      catch (IOException e)
      {
         System.out.println("rec2..Error in reading :" + e);
      }

      return(str);
   }

   synchronized public char[] ReceiveCharArray(DataInputStream dis)
   {
      String str = "";
      try
      {
         int len = Integer.parseInt(dis.readLine());

         byte by[] = new byte[len];
         dis.readFully(by);
         str = new String(by, len);
      }
      catch (IOException e)
      {
         System.out.println("rec2..Error in reading :" + e);
      }

      return(str.toCharArray());
   }

   public void ClosePorts()
   {
      Enumeration names;
      int status = 0;
      String portname;
      ServerSocket sk;
      String str = "";

      names  = groupids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();

         status = DeletePortGroup(str);
//         System.out.println("The deleted port group is : " + status);
      }
      groupids.clear();

      names = portids.keys();
      while(names.hasMoreElements())
      {
         str = (String) names.nextElement();

         status = DeletePort(str);
//         System.out.println("The deleted port is : " + status);
      }
      Socket for_deletehost = null;

      try
      {  
         for_deletehost = new Socket(servername, 4578);
      }
      catch (IOException e)
      {
         System.out.println("Error in making socket connection " + e);
      }
      try
      {  
         to_server = new PrintStream(for_deletehost.getOutputStream());
         from_server = new DataInputStream(for_deletehost.getInputStream());
      }
      catch (IOException e)
      {
         System.out.println("Error in opening streams " + e);
      }
      to_server.println("hostname");

//      System.out.println("...... hostname is " + hostname);
      String htname = read_hostname();
//      System.out.println("...... hostname is " + htname);
//      System.out.println("..... hostid is " + host_id);

      to_server.println(job_id);
      to_server.println(htname);
      to_server.println(host_id);
      to_server.println("remove");

      try
      {  
         status = Integer.parseInt(from_server.readLine());
      }
      catch (IOException e)
      {
         System.out.println("Del..Error in reading from server " + e);
      }
      System.out.println("The status of deleting the host is : " + status);
      try
      {  
         for_deletehost.close();
      }
      catch (IOException e)
      {
         System.out.println("Error in closing the sockets :" + e);
      }
   }
}

class groupsocket
{
   String groupname;
   int groupid;
   ServerSocket serversocket;

   public groupsocket(String gn, int gno, ServerSocket sk)
   {
      groupname = gn;
      groupid = gno;
      serversocket = sk;
   }
}

class portsocket
{
   String portname;
   int portid;
   ServerSocket serversocket;

   public portsocket(String pn, int pno, ServerSocket sk)
   {
      portname = pn;
      portid = pno;
      serversocket = sk;
   }
}
